/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.uima.ruta.ide.ui.text.RutaTextTools;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.environment.FileAsFileHandle;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;

public class RutaIdeUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.apache.uima.ruta.ide.ui";
    private RutaTextTools textTools;
    private BundleContext bundleContext;
    private static RutaIdeUIPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.bundleContext = context;
        this.checkRutaInterpreter();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static RutaIdeUIPlugin getDefault() {
        return plugin;
    }

    public synchronized RutaTextTools getTextTools() {
        if (this.textTools == null) {
            this.textTools = new RutaTextTools(true);
        }
        return this.textTools;
    }

    public static void error(String message, Throwable t) {
        plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, message, t));
    }

    public static void error(Throwable t) {
        RutaIdeUIPlugin.error(t.getMessage(), t);
    }

    public IFileHandle getConsoleProxy(IExecutionEnvironment exeEnv) throws IOException {
        IDeployment deployment = exeEnv.createDeployment();
        IPath path = deployment.add(this.getBundle(), "console");
        path.append("ConsoleProxy.ruta");
        return deployment.getFile(path);
    }

    public Bundle getBundle(String bundleName) {
        Bundle[] bundles = this.getBundles(bundleName, null);
        if (bundles != null && bundles.length > 0) {
            return bundles[0];
        }
        return null;
    }

    public Bundle[] getBundles(String bundleName, String version) {
        Bundle[] bundles = Platform.getBundles((String)bundleName, (String)version);
        if (bundles != null) {
            return bundles;
        }
        PackageAdmin admin = (PackageAdmin)this.bundleContext.getService(this.bundleContext.getServiceReference(PackageAdmin.class.getName()));
        bundles = admin.getBundles(bundleName, version);
        if (bundles != null && bundles.length > 0) {
            return bundles;
        }
        return null;
    }

    public String pluginIdToJarPath(String pluginId) throws IOException {
        Bundle bundle = this.getBundle(pluginId);
        URL url = bundle.getEntry("/");
        if (url == null) {
            throw new IOException();
        }
        return FileLocator.toFileURL((URL)url).getFile();
    }

    private void checkRutaInterpreter() throws IOException, CoreException {
        IEnvironment localEnv = LocalEnvironment.getInstance();
        ScriptRuntime.DefaultInterpreterEntry defaultInterpreterEntry = new ScriptRuntime.DefaultInterpreterEntry("org.apache.uima.ruta.ide.nature", localEnv.getId());
        IInterpreterInstall defaultInterpreterInstall = null;
        try {
            defaultInterpreterInstall = ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)defaultInterpreterEntry);
        }
        catch (Exception e) {
            RutaIdeUIPlugin.error(e);
        }
        if (defaultInterpreterInstall == null) {
            return;
        }
        IFileHandle rawInstallLocation = defaultInterpreterInstall.getRawInstallLocation();
        if (!rawInstallLocation.exists()) {
            String pluginIdToJarPath = this.pluginIdToJarPath(PLUGIN_ID);
            FileAsFileHandle fh = new FileAsFileHandle(new File(pluginIdToJarPath));
            defaultInterpreterInstall.setInstallLocation((IFileHandle)fh);
            ScriptRuntime.setDefaultInterpreterInstall((IInterpreterInstall)defaultInterpreterInstall, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

