/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.handlers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.testing.ui.views.TestPageBookView;
import org.apache.uima.ruta.testing.ui.views.TestViewPage;
import org.apache.uima.ruta.utils.ui.SelectTypesDialog;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class SelectedExcludedTypesHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TestPageBookView debugView = (TestPageBookView)HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(debugView.getCurrentPage() instanceof TestViewPage)) {
            return Status.CANCEL_STATUS;
        }
        TestViewPage activePage = (TestViewPage)debugView.getCurrentPage();
        IResource resource = activePage.getResource();
        IPath location = resource.getLocation();
        String preFilePath = location.toPortableString();
        File preFile = new File(preFilePath);
        if (!preFile.exists() || StringUtils.isEmpty((CharSequence)preFilePath)) {
            SelectedExcludedTypesHandler.printErrorDialog("The preprocessing file was not found!");
            return null;
        }
        TypeSystemDescription defaultTypeSystemDescription = null;
        ArrayList<String> types = new ArrayList<String>();
        try {
            String tsDesc = RutaProjectUtils.getTypeSystemDescriptorPath((IPath)location, (IProject)resource.getProject()).toPortableString();
            defaultTypeSystemDescription = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(new File(tsDesc)));
            defaultTypeSystemDescription.resolveImports();
            TypeDescription[] systemTypes = defaultTypeSystemDescription.getTypes();
            HashSet<String> set = new HashSet<String>();
            for (TypeDescription typeDescription : systemTypes) {
                set.add(typeDescription.getName());
            }
            types.addAll(set);
            Collections.sort(types);
        }
        catch (InvalidXMLException e) {
            RutaAddonsPlugin.error(e);
        }
        catch (IOException e) {
            RutaAddonsPlugin.error(e);
        }
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 67696);
        shell.setText("Select excluded types");
        SelectTypesDialog dialog = new SelectTypesDialog(shell, types, activePage.getExcludedTypes());
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        List<String> selectedTypes = dialog.getSelectedTypes();
        activePage.setExcludedTypes(selectedTypes);
        return Status.OK_STATUS;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public static void printErrorDialog(String error) {
        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"File not Found!", (String)error, (IStatus)new Status(4, "-1", "File not found!"));
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

