/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.util;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.model.dynamic.entity.impl.DynamicGroupImpl;
import org.apache.fulcrum.security.util.GroupSet;

public class GroupSetTest
extends TestCase {
    public GroupSetTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(GroupSetTest.class);
    }

    public void testNullGroup() throws Exception {
        GroupSet groupSet = new GroupSet();
        GroupSetTest.assertFalse((boolean)groupSet.contains(null));
    }

    public void testAddGroups() throws Exception {
        DynamicGroupImpl group = new DynamicGroupImpl();
        group.setId((Object)new Integer(1));
        group.setName("Eric");
        GroupSet groupSet = new GroupSet();
        GroupSetTest.assertTrue((boolean)groupSet.add((SecurityEntity)group));
        GroupSetTest.assertFalse((boolean)groupSet.add((SecurityEntity)group));
        GroupSetTest.assertTrue((boolean)groupSet.contains((Object)group));
        DynamicGroupImpl group2 = new DynamicGroupImpl();
        group2.setName("Kate");
        group2.setId((Object)new Integer(2));
        groupSet.add((SecurityEntity)group2);
        DynamicGroupImpl group3 = new DynamicGroupImpl();
        group3.setId((Object)new Integer(1));
        group3.setName("Eric");
        groupSet.add((SecurityEntity)group3);
        GroupSetTest.assertTrue((boolean)groupSet.contains((Object)group));
        GroupSetTest.assertTrue((boolean)groupSet.contains((Object)group));
        GroupSetTest.assertTrue((boolean)groupSet.contains((Object)group2));
        GroupSetTest.assertTrue((boolean)groupSet.contains((Object)group3));
        GroupSetTest.assertTrue((boolean)groupSet.contains((Object)group));
    }

    public void testGroupSetWithSubclass() throws Exception {
        GroupSet groupSet = new GroupSet();
        GroupSubClass group = new GroupSubClass();
        group.setId(new Integer(1));
        group.setName("Eric");
        groupSet.add((SecurityEntity)group);
        GroupSetTest.assertTrue((boolean)groupSet.contains((Object)group));
        DynamicGroupImpl group2 = new DynamicGroupImpl();
        group2.setId((Object)new Integer(1));
        group2.setName("Eric");
        GroupSetTest.assertTrue((boolean)groupSet.contains((Object)group2));
    }

    class GroupSubClass
    extends DynamicGroupImpl {
        private String extraGroupData;

        GroupSubClass() {
        }

        public String getExtraGroupData() {
            return this.extraGroupData;
        }

        public void setExtraGroupData(String extraGroupData) {
            this.extraGroupData = extraGroupData;
        }
    }
}

