/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceaccesssecurity.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.security.AccessSecurityException;
import org.apache.sling.api.security.ResourceAccessSecurity;
import org.apache.sling.resourceaccesssecurity.ResourceAccessGate;
import org.apache.sling.resourceaccesssecurity.impl.AccessGateResourceWrapper;
import org.apache.sling.resourceaccesssecurity.impl.ResourceAccessGateHandler;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public abstract class ResourceAccessSecurityImpl
implements ResourceAccessSecurity {
    private List<ResourceAccessGateHandler> allHandlers = Collections.emptyList();
    private final boolean defaultAllowIfNoGateMatches;

    protected ResourceAccessSecurityImpl(boolean defaultAllowIfNoGateMatches, List<ServiceReference<ResourceAccessGate>> resourceAccessGateRefs, ComponentContext componentContext, String resourceAccessGateReferenceName) {
        this.defaultAllowIfNoGateMatches = defaultAllowIfNoGateMatches;
        this.allHandlers = resourceAccessGateRefs.stream().sorted(Collections.reverseOrder()).map(ref -> new ResourceAccessGateHandler((ServiceReference<ResourceAccessGate>)ref, (ResourceAccessGate)componentContext.locateService(resourceAccessGateReferenceName, ref))).collect(Collectors.toList());
    }

    private Iterator<ResourceAccessGateHandler> getMatchingResourceAccessGateHandlerIterator(final String path, final ResourceAccessGate.Operation operation) {
        List<ResourceAccessGateHandler> handlers = this.allHandlers;
        if (!handlers.isEmpty()) {
            final Iterator<ResourceAccessGateHandler> iter = handlers.iterator();
            return new Iterator<ResourceAccessGateHandler>(){
                private ResourceAccessGateHandler next;
                {
                    this.peek();
                }

                private void peek() {
                    this.next = null;
                    while (iter.hasNext() && this.next == null) {
                        ResourceAccessGateHandler handler = (ResourceAccessGateHandler)iter.next();
                        if (!handler.matches(path, operation)) continue;
                        this.next = handler;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public ResourceAccessGateHandler next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    ResourceAccessGateHandler handler = this.next;
                    this.peek();
                    return handler;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return null;
    }

    public Resource getReadableResource(Resource resource) {
        Object returnValue = null;
        Iterator<ResourceAccessGateHandler> accessGateHandlers = this.getMatchingResourceAccessGateHandlerIterator(resource.getPath(), ResourceAccessGate.Operation.READ);
        ResourceAccessGate.GateResult finalGateResult = null;
        ArrayList<ResourceAccessGate> accessGatesForReadValues = null;
        boolean canReadAllValues = false;
        if (accessGateHandlers != null) {
            boolean noGateMatched = true;
            while (accessGateHandlers.hasNext()) {
                ResourceAccessGate.GateResult gateResult;
                noGateMatched = false;
                ResourceAccessGateHandler resourceAccessGateHandler = accessGateHandlers.next();
                ResourceAccessGate.GateResult gateResult2 = gateResult = !resourceAccessGateHandler.getResourceAccessGate().hasReadRestrictions(resource.getResourceResolver()) ? ResourceAccessGate.GateResult.GRANTED : resourceAccessGateHandler.getResourceAccessGate().canRead(resource);
                if (!canReadAllValues && gateResult == ResourceAccessGate.GateResult.GRANTED) {
                    if (resourceAccessGateHandler.getResourceAccessGate().canReadAllValues(resource)) {
                        canReadAllValues = true;
                        accessGatesForReadValues = null;
                    } else {
                        if (accessGatesForReadValues == null) {
                            accessGatesForReadValues = new ArrayList<ResourceAccessGate>();
                        }
                        accessGatesForReadValues.add(resourceAccessGateHandler.getResourceAccessGate());
                    }
                }
                if (finalGateResult == null || finalGateResult == ResourceAccessGate.GateResult.DENIED) {
                    finalGateResult = gateResult;
                }
                if (gateResult == ResourceAccessGate.GateResult.CANT_DECIDE || !resourceAccessGateHandler.isFinalOperation(ResourceAccessGate.Operation.READ)) continue;
                break;
            }
            if (finalGateResult == ResourceAccessGate.GateResult.DENIED) {
                returnValue = null;
            } else if (finalGateResult == ResourceAccessGate.GateResult.GRANTED) {
                returnValue = resource;
            } else if (noGateMatched && this.defaultAllowIfNoGateMatches) {
                returnValue = resource;
            }
        }
        boolean canUpdateResource = this.canUpdate(resource);
        if (!(returnValue == null || canReadAllValues && canUpdateResource)) {
            returnValue = new AccessGateResourceWrapper((Resource)returnValue, (List<ResourceAccessGate>)accessGatesForReadValues, canUpdateResource);
        }
        return returnValue;
    }

    private boolean canDoOperation(ResourceAccessGate.Operation operation, String path, Predicate<ResourceAccessGate> gatePredicate, Function<ResourceAccessGate, ResourceAccessGate.GateResult> gateResultFilter) {
        Iterator<ResourceAccessGateHandler> handlers = this.getMatchingResourceAccessGateHandlerIterator(path, operation);
        boolean result = false;
        if (handlers != null) {
            ResourceAccessGate.GateResult finalGateResult = null;
            boolean noGateMatched = true;
            while (handlers.hasNext()) {
                ResourceAccessGate.GateResult gateResult;
                noGateMatched = false;
                ResourceAccessGateHandler resourceAccessGateHandler = handlers.next();
                ResourceAccessGate.GateResult gateResult2 = gateResult = !gatePredicate.test(resourceAccessGateHandler.getResourceAccessGate()) ? ResourceAccessGate.GateResult.GRANTED : gateResultFilter.apply(resourceAccessGateHandler.getResourceAccessGate());
                if (finalGateResult == null || finalGateResult == ResourceAccessGate.GateResult.DENIED) {
                    finalGateResult = gateResult;
                }
                if (finalGateResult != ResourceAccessGate.GateResult.GRANTED && (gateResult == ResourceAccessGate.GateResult.CANT_DECIDE || !resourceAccessGateHandler.isFinalOperation(operation))) continue;
                break;
            }
            if (finalGateResult == ResourceAccessGate.GateResult.GRANTED || noGateMatched && this.defaultAllowIfNoGateMatches) {
                result = true;
            }
        }
        return result;
    }

    public boolean canOrderChildren(Resource resource) {
        return this.canDoOperation(ResourceAccessGate.Operation.ORDER_CHILDREN, resource.getPath(), gate -> gate.hasOrderChildrenRestrictions(resource.getResourceResolver()), gate -> gate.canOrderChildren(resource));
    }

    public boolean canCreate(String path, ResourceResolver resolver) {
        return this.canDoOperation(ResourceAccessGate.Operation.CREATE, path, gate -> gate.hasCreateRestrictions(resolver), gate -> gate.canCreate(path, resolver));
    }

    public boolean canUpdate(Resource resource) {
        return this.canDoOperation(ResourceAccessGate.Operation.UPDATE, resource.getPath(), gate -> gate.hasUpdateRestrictions(resource.getResourceResolver()), gate -> gate.canUpdate(resource));
    }

    public boolean canDelete(Resource resource) {
        return this.canDoOperation(ResourceAccessGate.Operation.DELETE, resource.getPath(), gate -> gate.hasDeleteRestrictions(resource.getResourceResolver()), gate -> gate.canDelete(resource));
    }

    public boolean canExecute(Resource resource) {
        return this.canDoOperation(ResourceAccessGate.Operation.EXECUTE, resource.getPath(), gate -> gate.hasExecuteRestrictions(resource.getResourceResolver()), gate -> gate.canExecute(resource));
    }

    public boolean canReadValue(Resource resource, String valueName) {
        return false;
    }

    public boolean canSetValue(Resource resource, String valueName) {
        return false;
    }

    public boolean canDeleteValue(Resource resource, String valueName) {
        return false;
    }

    public String transformQuery(String query, String language, ResourceResolver resourceResolver) throws AccessSecurityException {
        String returnValue = query;
        for (ResourceAccessGateHandler handler : this.allHandlers) {
            returnValue = handler.getResourceAccessGate().transformQuery(returnValue, language, resourceResolver);
            if (returnValue != null) continue;
            throw new AccessSecurityException("Method transformQuery in ResourceAccessGate " + handler.getResourceAccessGate().getClass().getName() + " returned null.");
        }
        return returnValue;
    }
}

