/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.commons;

import java.util.Collection;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.base.commons.UndefinedClusterViewException;

public class ClusterViewHelper {
    public static boolean contains(ClusterView clusterView, String slingId) throws UndefinedClusterViewException {
        InstanceDescription found = null;
        for (InstanceDescription i : clusterView.getInstances()) {
            if (!i.getSlingId().equals(slingId)) continue;
            if (found != null) {
                throw new IllegalStateException("multiple instances with slingId found: " + slingId);
            }
            found = i;
        }
        return found != null;
    }

    public static boolean containsAny(ClusterView clusterView, Collection<InstanceDescription> listInstances) throws UndefinedClusterViewException {
        for (InstanceDescription i : listInstances) {
            if (!ClusterViewHelper.contains(clusterView, i.getSlingId())) continue;
            return true;
        }
        return false;
    }
}

