/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.opengis.referencing.datum.Ellipsoid;

@XmlTransient
final class Sphere
extends DefaultEllipsoid {
    private static final long serialVersionUID = 7867565381280669821L;

    protected Sphere(Map<String, ?> properties, double radius, boolean ivfDefinitive, Unit<Length> unit) {
        super(properties, radius, radius, Double.POSITIVE_INFINITY, ivfDefinitive, unit);
    }

    @Override
    public boolean isSphere() {
        return true;
    }

    @Override
    public double getAuthalicRadius() {
        return this.getSemiMajorAxis();
    }

    @Override
    public double getEccentricity() {
        return 0.0;
    }

    @Override
    public double getEccentricitySquared() {
        return 0.0;
    }

    @Override
    public double flatteningDifference(Ellipsoid other) {
        return 1.0 / other.getInverseFlattening();
    }

    @Override
    public DefaultEllipsoid convertTo(Unit<Length> target) {
        UnitConverter c = this.getAxisUnit().getConverterTo(target);
        if (c.isIdentity()) {
            return this;
        }
        return new Sphere(this.properties(target), c.convert(this.getSemiMajorAxis()), this.isIvfDefinitive(), target);
    }
}

