/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.text.ParseException;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.NoSuchDataException;
import org.apache.sis.storage.sql.SQLStore;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public class DataAccess
implements AutoCloseable {
    protected final SQLStore store;
    private Connection connection;
    private InfoStatements spatialInformation;
    private Lock lock;
    protected final boolean write;
    private boolean isClosed;

    protected DataAccess(SQLStore store, boolean write) {
        this.store = Objects.requireNonNull(store);
        this.write = write;
    }

    final void setConnection(Connection connection, InfoStatements spatialInformation) {
        this.connection = connection;
        this.spatialInformation = spatialInformation;
    }

    public SQLStore getDataStore() {
        return this.store;
    }

    private String closed() {
        return Errors.forLocale((Locale)this.store.getLocale()).getString((short)31);
    }

    public final Connection getConnection() throws SQLException {
        if (this.isClosed) {
            throw new SQLNonTransientConnectionException(this.closed());
        }
        if (this.connection == null) {
            ReadWriteLock transactionLocks = this.store.transactionLocks;
            if (transactionLocks != null) {
                Lock c = this.write ? transactionLocks.writeLock() : transactionLocks.readLock();
                c.lock();
                this.lock = c;
            }
            this.connection = this.store.getDataSource().getConnection();
            Database<?> model = this.store.modelOrNull();
            if (model != null && model.dialect.supportsReadOnlyUpdate()) {
                this.connection.setReadOnly(!this.write);
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InfoStatements spatialInformation() throws Exception {
        if (this.spatialInformation == null) {
            Connection c = this.getConnection();
            SQLStore sQLStore = this.store;
            synchronized (sQLStore) {
                Database<?> model = this.store.model(c);
                if (model.dialect.supportsReadOnlyUpdate()) {
                    c.setReadOnly(!this.write);
                }
                this.spatialInformation = model.createInfoStatements(c);
            }
        }
        return this.spatialInformation;
    }

    public CoordinateReferenceSystem findCRS(int srid) throws DataStoreException {
        CoordinateReferenceSystem crs;
        if (this.isClosed) {
            throw new DataStoreClosedException(this.closed());
        }
        if (srid <= 0) {
            return null;
        }
        Database<?> database = this.store.modelOrNull();
        if (database == null || (crs = database.getCachedCRS(srid)) == null) {
            try {
                crs = this.spatialInformation().fetchCRS(srid);
            }
            catch (DataStoreContentException e) {
                throw new NoSuchDataException(e.getMessage(), e.getCause());
            }
            catch (ParseException | FactoryException e) {
                throw new DataStoreReferencingException(e.getMessage(), e);
            }
            catch (Exception e) {
                throw SQLStore.cannotExecute(e);
            }
        }
        return crs;
    }

    public int findSRID(CoordinateReferenceSystem crs) throws DataStoreException {
        int srid;
        Integer srid2;
        if (this.isClosed) {
            throw new DataStoreClosedException(this.closed());
        }
        if (crs == null) {
            return 0;
        }
        Database<?> database = this.store.modelOrNull();
        if (database != null && (srid2 = Integer.valueOf(database.getCachedSRID(crs))) != null) {
            return srid2;
        }
        try {
            srid = this.spatialInformation().findSRID(crs);
        }
        catch (Exception e) {
            throw SQLStore.cannotExecute(e);
        }
        return srid;
    }

    public Locale getLocale(Locale.Category category) {
        switch (category) {
            case DISPLAY: {
                return this.store.getLocale();
            }
            case FORMAT: {
                return this.store.contentLocale;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Object c;
        this.isClosed = true;
        try {
            try {
                c = this.spatialInformation;
                if (c != null) {
                    this.spatialInformation = null;
                    ((InfoStatements)c).close();
                }
            }
            finally {
                c = this.connection;
                if (c != null) {
                    this.connection = null;
                    c.close();
                }
            }
        }
        finally {
            c = this.lock;
            if (c != null) {
                this.lock = null;
                c.unlock();
            }
        }
    }
}

