/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.util.Collection;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.Resource;

public class MemoryFeatureSet
extends AbstractFeatureSet {
    private final DefaultFeatureType type;
    private final Collection<AbstractFeature> features;

    public MemoryFeatureSet(Resource parent, DefaultFeatureType type, Collection<AbstractFeature> features) {
        super(parent);
        this.type = Objects.requireNonNull(type);
        this.features = Objects.requireNonNull(features);
    }

    @Override
    public DefaultFeatureType getType() {
        return this.type;
    }

    @Override
    public OptionalLong getFeatureCount() {
        return OptionalLong.of(this.features.size());
    }

    @Override
    public Stream<AbstractFeature> features(boolean parallel) {
        return parallel ? this.features.parallelStream() : this.features.stream();
    }
}

