/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.ErrorAction;
import org.apache.sis.util.ArgumentChecks;

public interface ErrorHandler {
    public static final ErrorHandler THROW = ErrorAction.THROW;
    public static final ErrorHandler LOG = ErrorAction.LOG;

    public void handle(Report var1);

    public static class Report {
        private int[] indices;
        private int length;
        private LogRecord description;

        public synchronized boolean isEmpty() {
            return this.length == 0 && this.description == null;
        }

        private static boolean equals(Throwable t1, Throwable t2) {
            if (t1 == t2) {
                return true;
            }
            return t1 != null && t2 != null && t1.getClass() == t2.getClass() && Objects.equals(t1.getMessage(), t2.getMessage()) && Arrays.equals(t1.getStackTrace(), t2.getStackTrace());
        }

        private static void addSuppressed(Throwable error, Throwable more) {
            if (Report.equals(error, more) || Report.equals(error.getCause(), more)) {
                return;
            }
            for (Throwable s : error.getSuppressed()) {
                if (!Report.equals(s, more)) continue;
                return;
            }
            error.addSuppressed(more);
        }

        public synchronized boolean add(Point tile, Throwable error, Supplier<LogRecord> record) {
            ArgumentChecks.ensureNonNull((String)"error", (Object)error);
            if (tile != null) {
                if (this.indices == null) {
                    this.indices = new int[8];
                } else if (this.length >= this.indices.length) {
                    this.indices = Arrays.copyOf(this.indices, this.indices.length * 2);
                }
                this.indices[this.length++] = tile.x;
                this.indices[this.length++] = tile.y;
            }
            if (this.description == null) {
                if (record != null) {
                    this.description = record.get();
                }
                if (this.description == null) {
                    this.description = tile != null ? Resources.forLocale(null).createLogRecord(Level.WARNING, (short)9, tile.x, tile.y) : new LogRecord(Level.WARNING, error.toString());
                }
                this.description.setThrown(error);
                return true;
            }
            Report.addSuppressed(this.description.getThrown(), error);
            return false;
        }

        public synchronized Point[] getTileIndices() {
            Point[] p = new Point[this.length >>> 1];
            int i = 0;
            while (i < this.length) {
                p[i >>> 1] = new Point(this.indices[i++], this.indices[i++]);
            }
            return p;
        }

        public synchronized LogRecord getDescription() {
            return this.description;
        }
    }
}

