/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql.internal.shared;

import java.sql.DatabaseMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;

public final class SQLUtilities {
    private SQLUtilities() {
    }

    public static String getSimplifiedURL(DatabaseMetaData metadata) throws SQLException {
        int s2;
        String url = metadata.getURL();
        int s1 = url.indexOf(63);
        if (s1 < 0) {
            s1 = url.length();
        }
        if ((s2 = url.indexOf(59)) < 0) {
            s2 = url.length();
        }
        return url.substring(0, Math.min(s1, s2));
    }

    public static Boolean parseBoolean(String text) throws SQLException {
        if (text == null) {
            return null;
        }
        switch (text.length()) {
            case 0: {
                return null;
            }
            case 1: {
                switch (text.charAt(0)) {
                    case '0': 
                    case 'F': 
                    case 'N': 
                    case 'f': 
                    case 'n': {
                        return Boolean.FALSE;
                    }
                    case '1': 
                    case 'T': 
                    case 'Y': 
                    case 't': 
                    case 'y': {
                        return Boolean.TRUE;
                    }
                }
                break;
            }
            default: {
                if (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("yes")) {
                    return Boolean.TRUE;
                }
                if (!text.equalsIgnoreCase("false") && !text.equalsIgnoreCase("no")) break;
                return Boolean.FALSE;
            }
        }
        throw new SQLDataException(Errors.format((short)12, (Object)text, Boolean.class));
    }

    public static String escape(String text, String escape) {
        if (text != null && !Strings.isNullOrEmpty((String)escape)) {
            char escapeChar = escape.charAt(0);
            StringBuilder buffer = null;
            int i = text.length();
            while (--i >= 0) {
                char c = text.charAt(i);
                if (c != '_' && c != '%' && (c != escapeChar || !text.startsWith(escape, i))) continue;
                if (buffer == null) {
                    buffer = new StringBuilder(text);
                }
                buffer.insert(i, escape);
            }
            if (buffer != null) {
                return buffer.toString();
            }
        }
        return text;
    }

    public static String toLikePattern(String text, boolean toLowerCase, String escape) {
        StringBuilder buffer = new StringBuilder(text.length());
        SQLUtilities.toLikePattern(text, 0, text.length(), false, toLowerCase, escape, buffer);
        return buffer.toString();
    }

    public static void toLikePattern(String text, int textStart, int textEnd, boolean allowSuffix, boolean toLowerCase, String escape, StringBuilder buffer) {
        int bufferStart = buffer.length();
        while (textStart < textEnd) {
            int c = text.codePointAt(textStart);
            if (Character.isLetterOrDigit(c)) {
                if (c < 128 || c >= 1024) {
                    buffer.appendCodePoint(toLowerCase ? Character.toLowerCase(c) : c);
                } else {
                    SQLUtilities.appendIfNotRedundant(buffer, '_');
                }
            } else {
                int length = buffer.length();
                if (length == bufferStart) {
                    if (escape != null && (c == 37 || c == 95 || text.startsWith(escape, textStart))) {
                        buffer.append(escape);
                    }
                    buffer.appendCodePoint(c);
                } else if (buffer.charAt(length - 1) != '%') {
                    buffer.append('%');
                }
            }
            textStart += Character.charCount(c);
        }
        if (allowSuffix) {
            SQLUtilities.appendIfNotRedundant(buffer, '%');
        }
        int i = bufferStart;
        while ((i = buffer.indexOf("_%", i)) >= 0) {
            buffer.deleteCharAt(i);
        }
    }

    private static void appendIfNotRedundant(StringBuilder buffer, char wildcard) {
        int length = buffer.length();
        if (length == 0 || buffer.charAt(length - 1) != '%') {
            buffer.append(wildcard);
        }
    }

    public static boolean filterFalsePositive(String expected, String actual) {
        return CharSequences.equalsFiltered((CharSequence)expected, (CharSequence)actual, (Characters.Filter)Characters.Filter.LETTERS_AND_DIGITS, (boolean)false);
    }
}

