/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.style.validator.components.ComponentsCallbacksKeysCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.components.ComponentsExamplesKeysCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.components.ComponentsHeadersKeysCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.components.ComponentsLinksKeysCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.components.ComponentsParametersKeysCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.components.ComponentsRequestBodiesKeysCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.components.ComponentsResponsesKeysCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.components.ComponentsSchemasKeysCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.components.ComponentsSecuritySchemesKeysCaseValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.ComponentsValidator;
import org.apache.servicecomb.toolkit.oasv.validation.factory.ComponentsValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.HeaderValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.ParameterValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.RequestBodyValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.ResponseValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.SchemaValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.SecuritySchemeValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.components.ComponentsHeadersValuesValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.components.ComponentsParametersValuesValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.components.ComponentsRequestBodiesValuesValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.components.ComponentsResponsesValuesValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.components.ComponentsSchemasValuesValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.components.ComponentsSecuritySchemesValuesValidator;
import org.springframework.stereotype.Component;

@Component
public class DefaultComponentsValidatorFactory
implements ComponentsValidatorFactory {
    private HeaderValidatorFactory headerValidatorFactory;
    private ParameterValidatorFactory parameterValidatorFactory;
    private RequestBodyValidatorFactory requestBodyValidatorFactory;
    private ResponseValidatorFactory responseValidatorFactory;
    private SchemaValidatorFactory schemaValidatorFactory;
    private SecuritySchemeValidatorFactory securitySchemeValidatorFactory;

    public DefaultComponentsValidatorFactory(HeaderValidatorFactory headerValidatorFactory, ParameterValidatorFactory parameterValidatorFactory, RequestBodyValidatorFactory requestBodyValidatorFactory, ResponseValidatorFactory responseValidatorFactory, SchemaValidatorFactory schemaValidatorFactory, SecuritySchemeValidatorFactory securitySchemeValidatorFactory) {
        this.headerValidatorFactory = headerValidatorFactory;
        this.parameterValidatorFactory = parameterValidatorFactory;
        this.requestBodyValidatorFactory = requestBodyValidatorFactory;
        this.responseValidatorFactory = responseValidatorFactory;
        this.schemaValidatorFactory = schemaValidatorFactory;
        this.securitySchemeValidatorFactory = securitySchemeValidatorFactory;
    }

    public List<ComponentsValidator> create(FactoryOptions options) {
        ArrayList<ComponentsValidator> validators = new ArrayList<ComponentsValidator>();
        validators.add((ComponentsValidator)new ComponentsHeadersValuesValidator(this.headerValidatorFactory.create(options)));
        validators.add((ComponentsValidator)new ComponentsParametersValuesValidator(this.parameterValidatorFactory.create(options)));
        validators.add((ComponentsValidator)new ComponentsRequestBodiesValuesValidator(this.requestBodyValidatorFactory.create(options)));
        validators.add((ComponentsValidator)new ComponentsResponsesValuesValidator(this.responseValidatorFactory.create(options)));
        validators.add((ComponentsValidator)new ComponentsSchemasValuesValidator(this.schemaValidatorFactory.create(options)));
        validators.add((ComponentsValidator)new ComponentsSecuritySchemesValuesValidator(this.securitySchemeValidatorFactory.create(options)));
        this.addComponentsCallbacksKeysCaseValidator(validators, options);
        this.addComponentsExamplesKeysCaseValidator(validators, options);
        this.addComponentsHeadersKeysCaseValidator(validators, options);
        this.addComponentsLinksKeysCaseValidator(validators, options);
        this.addComponentsParametersKeysCaseValidator(validators, options);
        this.addComponentsRequestBodiesKeysCaseValidator(validators, options);
        this.addComponentsResponsesKeysCaseValidator(validators, options);
        this.addComponentsSchemasKeysCaseValidator(validators, options);
        this.addComponentsSecuritySchemesKeysCaseValidator(validators, options);
        return Collections.unmodifiableList(validators);
    }

    private void addComponentsCallbacksKeysCaseValidator(List<ComponentsValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("components.callbacks.key.case");
        if (expectedCase != null) {
            validators.add((ComponentsValidator)new ComponentsCallbacksKeysCaseValidator(expectedCase));
        }
    }

    private void addComponentsExamplesKeysCaseValidator(List<ComponentsValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("components.examples.key.case");
        if (expectedCase != null) {
            validators.add((ComponentsValidator)new ComponentsExamplesKeysCaseValidator(expectedCase));
        }
    }

    private void addComponentsHeadersKeysCaseValidator(List<ComponentsValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("components.headers.key.case");
        if (expectedCase != null) {
            validators.add((ComponentsValidator)new ComponentsHeadersKeysCaseValidator(expectedCase));
        }
    }

    private void addComponentsLinksKeysCaseValidator(List<ComponentsValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("components.links.key.case");
        if (expectedCase != null) {
            validators.add((ComponentsValidator)new ComponentsLinksKeysCaseValidator(expectedCase));
        }
    }

    private void addComponentsParametersKeysCaseValidator(List<ComponentsValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("components.parameters.key.case");
        if (expectedCase != null) {
            validators.add((ComponentsValidator)new ComponentsParametersKeysCaseValidator(expectedCase));
        }
    }

    private void addComponentsRequestBodiesKeysCaseValidator(List<ComponentsValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("components.requestBodies.key.case");
        if (expectedCase != null) {
            validators.add((ComponentsValidator)new ComponentsRequestBodiesKeysCaseValidator(expectedCase));
        }
    }

    private void addComponentsResponsesKeysCaseValidator(List<ComponentsValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("components.responses.key.case");
        if (expectedCase != null) {
            validators.add((ComponentsValidator)new ComponentsResponsesKeysCaseValidator(expectedCase));
        }
    }

    private void addComponentsSchemasKeysCaseValidator(List<ComponentsValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("components.schemas.key.case");
        if (expectedCase != null) {
            validators.add((ComponentsValidator)new ComponentsSchemasKeysCaseValidator(expectedCase));
        }
    }

    private void addComponentsSecuritySchemesKeysCaseValidator(List<ComponentsValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("components.securitySchemes.key.case");
        if (expectedCase != null) {
            validators.add((ComponentsValidator)new ComponentsSecuritySchemesKeysCaseValidator(expectedCase));
        }
    }
}

