/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.cli;

import com.google.common.base.Charsets;
import io.airlift.airline.Option;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringJoiner;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.servicecomb.toolkit.cli.ValidationFailedException;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.style.StyleCheckParser;
import org.apache.servicecomb.toolkit.oasv.style.factory.ValidatorFactoryComponents;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasSpecValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.factory.OasSpecValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class CheckStyleBase
implements Runnable {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Option(name={"-r", "--rules-file"}, title="rules properties file", required=true, description="rules properties file")
    private String rulesFile;
    @Option(name={"-f", "--file"}, title="OpenAPI v3 spec yaml", required=true, description="OpenAPI v3 spec yaml")
    private String filePath;

    @Override
    public void run() {
        FactoryOptions factoryOptions;
        try {
            factoryOptions = this.loadFactoryOptions();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String yaml = null;
        try {
            yaml = this.loadFileContent(this.filePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SwaggerParseResult parseResult = StyleCheckParser.parseYaml((String)yaml);
        OpenAPI openAPI = parseResult.getOpenAPI();
        if (openAPI == null) {
            StringJoiner sj = new StringJoiner("\n");
            if (CollectionUtils.isNotEmpty((Collection)parseResult.getMessages())) {
                for (String message : parseResult.getMessages()) {
                    sj.add(message);
                }
            }
            throw new RuntimeException(sj.toString());
        }
        OasSpecValidator oasSpecValidator = this.createOasSpecValidator(factoryOptions);
        List violations = oasSpecValidator.validate(this.createContext(openAPI), openAPI);
        if (CollectionUtils.isNotEmpty((Collection)violations)) {
            for (OasViolation violation : violations) {
                this.LOGGER.info("path  : {}\nerror : {}\n------", (Object)OasObjectPropertyLocation.toPathString((OasObjectPropertyLocation)violation.getLocation()), (Object)violation.getError());
            }
            throw new ValidationFailedException("check not passed");
        }
        this.LOGGER.info("Everything is good");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OasSpecValidator createOasSpecValidator(FactoryOptions factoryOptions) {
        try (AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext(new Class[]{ValidatorFactoryComponents.class});){
            OasSpecValidatorFactory oasSpecValidatorFactory = (OasSpecValidatorFactory)ctx.getBean(OasSpecValidatorFactory.class);
            OasSpecValidator oasSpecValidator = oasSpecValidatorFactory.create(factoryOptions);
            return oasSpecValidator;
        }
    }

    private String loadFileContent(String filePath) throws IOException {
        Path specPath = Paths.get(filePath, new String[0]);
        return FileUtils.readFileToString((File)specPath.toFile(), (Charset)Charsets.UTF_8);
    }

    private OasValidationContext createContext(OpenAPI openAPI) {
        OasValidationContext oasValidationContext = new OasValidationContext(openAPI);
        return oasValidationContext;
    }

    private FactoryOptions loadFactoryOptions() throws IOException {
        Path specPath = Paths.get(this.rulesFile, new String[0]);
        specPath.toAbsolutePath().toString();
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(specPath.toFile());){
            properties.load(fis);
        }
        return new FactoryOptions(properties);
    }
}

