/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sts.model.StsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWebIdentityTokenResponse
extends StsResponse
implements ToCopyableBuilder<Builder, GetWebIdentityTokenResponse> {
    private static final SdkField<String> WEB_IDENTITY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebIdentityToken").getter(GetWebIdentityTokenResponse.getter(GetWebIdentityTokenResponse::webIdentityToken)).setter(GetWebIdentityTokenResponse.setter(Builder::webIdentityToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebIdentityToken").build()}).build();
    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Expiration").getter(GetWebIdentityTokenResponse.getter(GetWebIdentityTokenResponse::expiration)).setter(GetWebIdentityTokenResponse.setter(Builder::expiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_IDENTITY_TOKEN_FIELD, EXPIRATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWebIdentityTokenResponse.memberNameToFieldInitializer();
    private final String webIdentityToken;
    private final Instant expiration;

    private GetWebIdentityTokenResponse(BuilderImpl builder) {
        super(builder);
        this.webIdentityToken = builder.webIdentityToken;
        this.expiration = builder.expiration;
    }

    public final String webIdentityToken() {
        return this.webIdentityToken;
    }

    public final Instant expiration() {
        return this.expiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.webIdentityToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebIdentityTokenResponse)) {
            return false;
        }
        GetWebIdentityTokenResponse other = (GetWebIdentityTokenResponse)((Object)obj);
        return Objects.equals(this.webIdentityToken(), other.webIdentityToken()) && Objects.equals(this.expiration(), other.expiration());
    }

    public final String toString() {
        return ToString.builder((String)"GetWebIdentityTokenResponse").add("WebIdentityToken", (Object)(this.webIdentityToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Expiration", (Object)this.expiration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebIdentityToken": {
                return Optional.ofNullable(clazz.cast(this.webIdentityToken()));
            }
            case "Expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WebIdentityToken", WEB_IDENTITY_TOKEN_FIELD);
        map.put("Expiration", EXPIRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWebIdentityTokenResponse, T> g) {
        return obj -> g.apply((GetWebIdentityTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StsResponse.BuilderImpl
    implements Builder {
        private String webIdentityToken;
        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebIdentityTokenResponse model) {
            super(model);
            this.webIdentityToken(model.webIdentityToken);
            this.expiration(model.expiration);
        }

        public final String getWebIdentityToken() {
            return this.webIdentityToken;
        }

        public final void setWebIdentityToken(String webIdentityToken) {
            this.webIdentityToken = webIdentityToken;
        }

        @Override
        public final Builder webIdentityToken(String webIdentityToken) {
            this.webIdentityToken = webIdentityToken;
            return this;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        @Override
        public GetWebIdentityTokenResponse build() {
            return new GetWebIdentityTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWebIdentityTokenResponse> {
        public Builder webIdentityToken(String var1);

        public Builder expiration(Instant var1);
    }
}

