/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.testing;

import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.ArrayType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.ArithmeticUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.testing.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.netbeans.spi.java.hints.MatcherUtilities;

public class Tiny {
    public static ErrorDescription assertEqualsForArrays(HintContext ctx) {
        TypeKind kind;
        TypeMirror type;
        TypeElement ojAssert = ctx.getInfo().getElements().getTypeElement("org.junit.Assert");
        TypeElement oj5Assertion = ctx.getInfo().getElements().getTypeElement("org.junit.jupiter.api.Assertions");
        String targetPattern = null;
        if (ojAssert != null) {
            for (ExecutableElement ee : ElementFilter.methodsIn(ojAssert.getEnclosedElements())) {
                if (!ee.getSimpleName().contentEquals("assertArrayEquals")) continue;
                if (ctx.getVariables().containsKey("$message")) {
                    targetPattern = "org.junit.Assert.assertArrayEquals($message, $expected, $actual)";
                    continue;
                }
                targetPattern = "org.junit.Assert.assertArrayEquals($expected, $actual)";
            }
        } else if (oj5Assertion != null) {
            for (ExecutableElement ee : ElementFilter.methodsIn(ojAssert.getEnclosedElements())) {
                if (!ee.getSimpleName().contentEquals("assertArrayEquals")) continue;
                if (ctx.getVariables().containsKey("$message")) {
                    targetPattern = "org.junit.jupiter.api.Assertions.assertArrayEquals($expected, $actual, $message)";
                    continue;
                }
                targetPattern = "org.junit.jupiter.api.Assertions.assertArrayEquals($expected, $actual)";
            }
        }
        if ((type = ctx.getInfo().getTrees().getTypeMirror(ctx.getVariables().get("$expected"))) != null && type.getKind() == TypeKind.ARRAY && ((kind = ((ArrayType)type).getComponentType().getKind()) == TypeKind.DOUBLE || kind == TypeKind.FLOAT)) {
            targetPattern = null;
        }
        if (targetPattern != null) {
            Fix fix = JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_assertEqualsForArrays(), ctx.getPath(), targetPattern);
            return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_assertEqualsForArrays(), fix);
        }
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_assertEqualsForArrays(), new Fix[0]);
    }

    public static ErrorDescription mismatchedConstantVSReal(HintContext ctx) {
        if (Tiny.isConstant(ctx, "$expected") || !Tiny.isConstant(ctx, "$actual")) {
            return null;
        }
        if (!MatcherUtilities.matches(ctx, ctx.getPath(), "$method($arguments$)", true)) {
            return null;
        }
        TypeElement oj5Assertion = ctx.getInfo().getElements().getTypeElement("org.junit.jupiter.api.Assertions");
        String targetPattern = null;
        targetPattern = ctx.getVariables().containsKey("$message") ? (oj5Assertion == null ? "$method($message, $actual, $expected)" : "$method($actual, $expected, $message)") : "$method($actual, $expected)";
        Fix fix = JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_assertEqualsMismatchedConstantVSReal(), ctx.getPath(), targetPattern);
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_assertEqualsMismatchedConstantVSReal(), fix);
    }

    private static boolean isConstant(HintContext ctx, String variable) {
        TreePath variablePath = ctx.getVariables().get(variable);
        return Utilities.isConstantString(ctx.getInfo(), variablePath, true) || ArithmeticUtilities.compute(ctx.getInfo(), variablePath, true) != null;
    }

    public static ErrorDescription incovertibleTypes(HintContext ctx) {
        TypeMirror expected = ctx.getInfo().getTrees().getTypeMirror(ctx.getVariables().get("$expected"));
        TypeMirror actual = ctx.getInfo().getTrees().getTypeMirror(ctx.getVariables().get("$actual"));
        if (!Tiny.isAcceptable(ctx.getInfo(), expected) || !Tiny.isAcceptable(ctx.getInfo(), actual)) {
            return null;
        }
        if (ctx.getInfo().getTypes().isSubtype(expected, actual)) {
            return null;
        }
        if (ctx.getInfo().getTypes().isSubtype(actual, expected)) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_assertEqualsIncovertibleTypes(), new Fix[0]);
    }

    private static boolean isAcceptable(CompilationInfo info, TypeMirror type) {
        if (!Utilities.isValidType(type)) {
            return false;
        }
        TypeKind typeKind = type.getKind();
        return typeKind != TypeKind.EXECUTABLE && typeKind != TypeKind.PACKAGE;
    }
}

