/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.amazoncloudsearch;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputCheckActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputHistoryActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputNotifyActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.agents.output.amazoncloudsearch.DocumentChunkManager;
import org.apache.manifoldcf.agents.output.amazoncloudsearch.DocumentRecord;
import org.apache.manifoldcf.agents.output.amazoncloudsearch.Messages;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.connectorcommon.jsongen.JSONArrayReader;
import org.apache.manifoldcf.connectorcommon.jsongen.JSONNameValueReader;
import org.apache.manifoldcf.connectorcommon.jsongen.JSONObjectReader;
import org.apache.manifoldcf.connectorcommon.jsongen.JSONReader;
import org.apache.manifoldcf.connectorcommon.jsongen.JSONStringReader;
import org.apache.manifoldcf.connectorcommon.jsongen.JSONValueReader;
import org.apache.manifoldcf.core.common.DateParser;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.TempFileInput;
import org.apache.manifoldcf.core.interfaces.VersionContext;

public class AmazonCloudSearchConnector
extends BaseOutputConnector {
    public static final String INGEST_ACTIVITY = "document ingest";
    public static final String REMOVE_ACTIVITY = "document deletion";
    private static final String EDIT_CONFIGURATION_JS = "editConfiguration.js";
    private static final String EDIT_CONFIGURATION_HTML = "editConfiguration.html";
    private static final String VIEW_CONFIGURATION_HTML = "viewConfiguration.html";
    protected HttpPost poster = null;
    protected String serverHost = null;
    protected String serverPath = null;
    private DocumentChunkManager documentChunkManager = null;
    private static final String FILE_BODY_TEXT_FIELDNAME = "f_bodytext";
    private static final String DOCUMENT_URI_FIELDNAME = "document_URI";
    private static final Set<String> acceptableMimeTypes = new HashSet<String>();
    protected static final int CHUNK_SIZE = 1000;

    public void clearThreadContext() {
        super.clearThreadContext();
        this.documentChunkManager = null;
    }

    public void install(IThreadContext threadContext) throws ManifoldCFException {
        IDBInterface mainDatabase = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        DocumentChunkManager dcmanager = new DocumentChunkManager(mainDatabase);
        dcmanager.install();
    }

    public void deinstall(IThreadContext threadContext) throws ManifoldCFException {
        IDBInterface mainDatabase = DBInterfaceFactory.make((IThreadContext)threadContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        DocumentChunkManager dcmanager = new DocumentChunkManager(mainDatabase);
        dcmanager.deinstall();
    }

    public String[] getActivitiesList() {
        return new String[]{INGEST_ACTIVITY, REMOVE_ACTIVITY};
    }

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
    }

    public boolean isConnected() {
        return this.poster != null;
    }

    public void disconnect() throws ManifoldCFException {
        this.serverHost = null;
        this.serverPath = null;
        this.poster = null;
        super.disconnect();
    }

    protected void getSession() throws ManifoldCFException {
        if (this.documentChunkManager == null) {
            IDBInterface databaseHandle = DBInterfaceFactory.make((IThreadContext)this.currentContext, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
            this.documentChunkManager = new DocumentChunkManager(databaseHandle);
        }
        this.serverHost = this.params.getParameter("serverhost");
        if (this.serverHost == null) {
            throw new ManifoldCFException("Server host parameter required");
        }
        this.serverPath = this.params.getParameter("serverpath");
        if (this.serverPath == null) {
            throw new ManifoldCFException("Server path parameter required");
        }
        String proxyProtocol = this.params.getParameter("proxyprotocol");
        String proxyHost = this.params.getParameter("proxyhost");
        String proxyPort = this.params.getParameter("proxyport");
        String urlStr = "https://" + this.serverHost + this.serverPath;
        this.poster = new HttpPost(urlStr);
        if (proxyHost != null && proxyHost.length() > 0) {
            try {
                HttpHost proxy = new HttpHost(proxyHost, Integer.parseInt(proxyPort), proxyProtocol);
                RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                this.poster.setConfig(config);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Number format exception: " + e.getMessage(), (Throwable)e);
            }
        }
        this.poster.addHeader("Content-Type", "application/json");
    }

    public String check() throws ManifoldCFException {
        try {
            this.getSession();
            String responsbody = this.postData((InputStream)new ReaderInputStream((Reader)new StringReader("[]"), Consts.UTF_8));
            String status = "";
            try {
                status = this.getStatusFromJsonResponse(responsbody);
            }
            catch (ManifoldCFException e) {
                Logging.ingest.debug((Object)e);
                return "Could not get status from response body. Check Access Policy setting of your domain of Amazon CloudSearch.: " + e.getMessage();
            }
            if ("error".equalsIgnoreCase(status)) {
                return "Connection working. responsbody : " + responsbody;
            }
            return "Connection NOT working. responsbody : " + responsbody;
        }
        catch (ServiceInterruption e) {
            Logging.ingest.debug((Object)e);
            return "Transient exception: " + e.getMessage();
        }
    }

    private String getStatusFromJsonResponse(String responsbody) throws ManifoldCFException {
        try {
            JsonParser parser = new JsonFactory().createParser(responsbody);
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String name = parser.getCurrentName();
                if (!"status".equalsIgnoreCase(name)) continue;
                parser.nextToken();
                return parser.getText();
            }
        }
        catch (JsonParseException e) {
            throw new ManifoldCFException((Throwable)e);
        }
        catch (IOException e) {
            throw new ManifoldCFException((Throwable)e);
        }
        return null;
    }

    private String parseMessage(JsonParser parser) throws JsonParseException, IOException {
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            String name = parser.getCurrentName();
            if (!"message".equalsIgnoreCase(name)) continue;
            parser.nextToken();
            return parser.getText();
        }
        return null;
    }

    public boolean checkMimeTypeIndexable(VersionContext outputDescription, String mimeType, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (mimeType == null) {
            return false;
        }
        return acceptableMimeTypes.contains(mimeType.toLowerCase(Locale.ROOT));
    }

    public int addOrReplaceDocumentWithException(String documentURI, VersionContext outputDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        this.getSession();
        String uid = ManifoldCF.hash((String)documentURI);
        JSONObjectReader objectReader = new JSONObjectReader();
        JSONObjectReader fieldReader = new JSONObjectReader();
        objectReader.addNameValuePair(new JSONNameValueReader(new JSONStringReader("id"), (JSONReader)new JSONStringReader(uid))).addNameValuePair(new JSONNameValueReader(new JSONStringReader("type"), (JSONReader)new JSONStringReader("add"))).addNameValuePair(new JSONNameValueReader(new JSONStringReader("fields"), (JSONReader)fieldReader));
        Iterator itr = document.getFields();
        while (itr.hasNext()) {
            int i;
            String fieldName = (String)itr.next();
            Object[] fieldValues = document.getField(fieldName);
            JSONReader[] elements = new JSONReader[fieldValues.length];
            if (fieldValues instanceof Reader[]) {
                for (i = 0; i < elements.length; ++i) {
                    elements[i] = new JSONStringReader((Reader)fieldValues[i]);
                }
            } else if (fieldValues instanceof Date[]) {
                for (i = 0; i < elements.length; ++i) {
                    elements[i] = new JSONStringReader(DateParser.formatISO8601Date((Date)((Date)fieldValues[i])));
                }
            } else if (fieldValues instanceof String[]) {
                for (i = 0; i < elements.length; ++i) {
                    elements[i] = new JSONStringReader((String)fieldValues[i]);
                }
            } else {
                throw new IllegalStateException("Unexpected metadata type: " + fieldValues.getClass().getName());
            }
            fieldReader.addNameValuePair(new JSONNameValueReader(new JSONStringReader(fieldName), (JSONReader)new JSONArrayReader(elements)));
        }
        fieldReader.addNameValuePair(new JSONNameValueReader(new JSONStringReader(DOCUMENT_URI_FIELDNAME), (JSONReader)new JSONStringReader(documentURI)));
        fieldReader.addNameValuePair(new JSONNameValueReader(new JSONStringReader(FILE_BODY_TEXT_FIELDNAME), (JSONReader)new JSONStringReader((Reader)new InputStreamReader(document.getBinaryStream(), Consts.UTF_8))));
        this.documentChunkManager.recordDocument(uid, this.serverHost, this.serverPath, documentURI, INGEST_ACTIVITY, new Long(document.getBinaryLength()), (InputStream)new ReaderInputStream((Reader)objectReader, Consts.UTF_8));
        this.conditionallyFlushDocuments((IOutputHistoryActivity)activities);
        return 0;
    }

    public void removeDocument(String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        String uid = ManifoldCF.hash((String)documentURI);
        JSONObjectReader objectReader = new JSONObjectReader();
        objectReader.addNameValuePair(new JSONNameValueReader(new JSONStringReader("id"), (JSONReader)new JSONStringReader(uid))).addNameValuePair(new JSONNameValueReader(new JSONStringReader("type"), (JSONReader)new JSONStringReader("delete")));
        try {
            this.documentChunkManager.recordDocument(uid, this.serverHost, this.serverPath, documentURI, REMOVE_ACTIVITY, null, (InputStream)new ReaderInputStream((Reader)objectReader, Consts.UTF_8));
        }
        catch (IOException e) {
            AmazonCloudSearchConnector.handleIOException(e);
        }
        this.conditionallyFlushDocuments((IOutputHistoryActivity)activities);
    }

    public void noteJobComplete(IOutputNotifyActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        this.flushDocuments((IOutputHistoryActivity)activities);
    }

    protected void conditionallyFlushDocuments(IOutputHistoryActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (this.documentChunkManager.equalOrMoreThan(this.serverHost, this.serverPath, 1000)) {
            this.flushDocuments(activities);
        }
    }

    protected void flushDocuments(IOutputHistoryActivity activities) throws ManifoldCFException, ServiceInterruption {
        Logging.ingest.info((Object)"AmazonCloudSearch: Starting flush to Amazon");
        int chunkNumber = 0;
        while (true) {
            DocumentRecord[] records = this.documentChunkManager.readChunk(this.serverHost, this.serverPath, 1000);
            try {
                if (records.length != 0) {
                    JSONArrayReader arrayReader = new JSONArrayReader();
                    for (DocumentRecord dr : records) {
                        arrayReader.addArrayElement((JSONReader)new JSONValueReader((Reader)new InputStreamReader(dr.getDataStream(), Consts.UTF_8)));
                    }
                    String responsbody = this.postData((InputStream)new ReaderInputStream((Reader)arrayReader, Consts.UTF_8));
                    String status = this.getStatusFromJsonResponse(responsbody);
                    if ("success".equals(status)) {
                        for (DocumentRecord dr : records) {
                            activities.recordActivity(null, dr.getActivity(), dr.getDataSize(), dr.getUri(), "OK", null);
                        }
                        Logging.ingest.info((Object)("AmazonCloudSearch: Successfully sent document chunk " + chunkNumber));
                        this.documentChunkManager.deleteChunk(records);
                        continue;
                    }
                    for (DocumentRecord dr : records) {
                        activities.recordActivity(null, dr.getActivity(), dr.getDataSize(), dr.getUri(), "FAILED", responsbody);
                    }
                    Logging.ingest.error((Object)("AmazonCloudSearch: Error sending document chunk " + chunkNumber + ": '" + responsbody + "'"));
                    throw new ManifoldCFException("Received error status from service after feeding document.  Response body: '" + responsbody + "'");
                }
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) {
                    throw e;
                }
                for (DocumentRecord dr : records) {
                    activities.recordActivity(null, dr.getActivity(), dr.getDataSize(), dr.getUri(), ((Object)((Object)e)).getClass().getSimpleName().toUpperCase(Locale.ROOT), e.getMessage());
                }
                throw e;
            }
            catch (ServiceInterruption e) {
                for (DocumentRecord dr : records) {
                    activities.recordActivity(null, dr.getActivity(), dr.getDataSize(), dr.getUri(), ((Object)((Object)e)).getClass().getSimpleName().toUpperCase(Locale.ROOT), e.getMessage());
                }
                throw e;
            }
            finally {
                Throwable exception = null;
                for (DocumentRecord dr : records) {
                    try {
                        dr.close();
                    }
                    catch (Throwable e) {
                        exception = e;
                    }
                }
                if (exception == null) continue;
                if (exception instanceof ManifoldCFException) {
                    throw (ManifoldCFException)exception;
                }
                if (exception instanceof Error) {
                    throw (Error)exception;
                }
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException("Unknown exception class thrown: " + exception.getClass().getName() + ": " + exception.getMessage(), exception);
                continue;
            }
            break;
        }
    }

    private static void fillInServerConfigurationMap(Map<String, Object> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String serverhost = parameters.getParameter("serverhost");
        String serverpath = parameters.getParameter("serverpath");
        String proxyprotocol = parameters.getParameter("proxyprotocol");
        String proxyhost = parameters.getParameter("proxyhost");
        String proxyport = parameters.getParameter("proxyport");
        if (serverhost == null) {
            serverhost = "";
        }
        if (serverpath == null) {
            serverpath = "/2013-01-01/documents/batch";
        }
        if (proxyprotocol == null) {
            proxyprotocol = "http";
        }
        if (proxyhost == null) {
            proxyhost = "";
        }
        if (proxyport == null) {
            proxyport = "";
        }
        newMap.put("SERVERHOST", serverhost);
        newMap.put("SERVERPATH", serverpath);
        newMap.put("PROXYPROTOCOL", proxyprotocol);
        newMap.put("PROXYHOST", proxyhost);
        newMap.put("PROXYPORT", proxyport);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        AmazonCloudSearchConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIGURATION_HTML, paramMap);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "AmazonCloudSearchOutputConnector.ServerTabName"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        AmazonCloudSearchConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_JS, paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TABNAME", tabName);
        AmazonCloudSearchConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_HTML, paramMap);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String proxyport;
        String proxyhost;
        String proxyprotocol;
        String serverpath;
        String serverhost = variableContext.getParameter("serverhost");
        if (serverhost != null) {
            parameters.setParameter("serverhost", serverhost);
        }
        if ((serverpath = variableContext.getParameter("serverpath")) != null) {
            parameters.setParameter("serverpath", serverpath);
        }
        if ((proxyprotocol = variableContext.getParameter("proxyprotocol")) != null) {
            parameters.setParameter("proxyprotocol", proxyprotocol);
        }
        if ((proxyhost = variableContext.getParameter("proxyhost")) != null) {
            parameters.setParameter("proxyhost", proxyhost);
        }
        if ((proxyport = variableContext.getParameter("proxyport")) != null) {
            parameters.setParameter("proxyport", proxyport);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postData(InputStream jsonData) throws ServiceInterruption, ManifoldCFException {
        block15: {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            try {
                String string;
                TempFileInput bi = new TempFileInput(jsonData);
                try {
                    this.poster.setEntity((HttpEntity)new InputStreamEntity(bi.getStream(), bi.getLength()));
                    CloseableHttpResponse res = httpclient.execute((HttpUriRequest)this.poster);
                    HttpEntity resEntity = res.getEntity();
                    string = EntityUtils.toString((HttpEntity)resEntity);
                }
                catch (Throwable throwable) {
                    try {
                        bi.discard();
                        throw throwable;
                    }
                    catch (ClientProtocolException e) {
                        throw new ManifoldCFException((Throwable)e);
                    }
                    catch (IOException e) {
                        AmazonCloudSearchConnector.handleIOException(e);
                        break block15;
                    }
                }
                bi.discard();
                return string;
            }
            finally {
                try {
                    httpclient.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        Logging.ingest.warn((Object)("Amazon CloudSearch: IO exception: " + e.getMessage()), (Throwable)e);
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    static {
        acceptableMimeTypes.add("text/plain;charset=utf-8");
        acceptableMimeTypes.add("text/plain;charset=ascii");
        acceptableMimeTypes.add("text/plain;charset=us-ascii");
        acceptableMimeTypes.add("text/plain");
    }
}

