/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.spec.HMACParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.HmacSHA1;
import org.jcp.xml.dsig.internal.MacOutputStream;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DOMHMACSignatureMethod
extends DOMSignatureMethod {
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal.dom");
    private HmacSHA1 hmac = new HmacSHA1();
    private int outputLength;

    public DOMHMACSignatureMethod(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        super("http://www.w3.org/2000/09/xmldsig#hmac-sha1", algorithmParameterSpec);
    }

    public DOMHMACSignatureMethod(Element element) throws MarshalException {
        super(element);
    }

    protected void checkParams(SignatureMethodParameterSpec signatureMethodParameterSpec) throws InvalidAlgorithmParameterException {
        if (signatureMethodParameterSpec != null) {
            if (!(signatureMethodParameterSpec instanceof HMACParameterSpec)) {
                throw new InvalidAlgorithmParameterException("params must be of type HMACParameterSpec");
            }
            this.outputLength = ((HMACParameterSpec)signatureMethodParameterSpec).getOutputLength();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Setting outputLength from HMACParameterSpec to: " + this.outputLength);
            }
        } else {
            this.outputLength = -1;
        }
    }

    protected SignatureMethodParameterSpec unmarshalParams(Element element) throws MarshalException {
        this.outputLength = new Integer(element.getFirstChild().getNodeValue());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "unmarshalled outputLength: " + this.outputLength);
        }
        return new HMACParameterSpec(this.outputLength);
    }

    protected void marshalParams(Element element, String string) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(element);
        Element element2 = DOMUtils.createElement(document, "HMACOutputLength", "http://www.w3.org/2000/09/xmldsig#", string);
        element2.appendChild(document.createTextNode(String.valueOf(this.outputLength)));
        element.appendChild(element2);
    }

    public boolean verify(Key key, DOMSignedInfo dOMSignedInfo, byte[] byArray, XMLValidateContext xMLValidateContext) throws InvalidKeyException, SignatureException, XMLSignatureException {
        if (key == null || dOMSignedInfo == null || byArray == null) {
            throw new NullPointerException("key, signedinfo or signature data can't be null");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "outputLength = " + this.outputLength);
        }
        this.hmac.init(key, this.outputLength);
        dOMSignedInfo.canonicalize(xMLValidateContext, new MacOutputStream(this.hmac));
        return this.hmac.verify(byArray);
    }

    public byte[] sign(Key key, DOMSignedInfo dOMSignedInfo, XMLSignContext xMLSignContext) throws InvalidKeyException, XMLSignatureException {
        if (key == null || dOMSignedInfo == null) {
            throw new NullPointerException();
        }
        this.hmac.init(key, this.outputLength);
        dOMSignedInfo.canonicalize(xMLSignContext, new MacOutputStream(this.hmac));
        try {
            return this.hmac.sign();
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException.getMessage());
        }
    }

    public boolean paramsEqual(AlgorithmParameterSpec algorithmParameterSpec) {
        if (this.getParameterSpec() == algorithmParameterSpec) {
            return true;
        }
        if (!(algorithmParameterSpec instanceof HMACParameterSpec)) {
            return false;
        }
        HMACParameterSpec hMACParameterSpec = (HMACParameterSpec)algorithmParameterSpec;
        return this.outputLength == hMACParameterSpec.getOutputLength();
    }
}

