/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig.keyinfo;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.KeyException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;

public abstract class KeyInfoFactory {
    private String mechanismType;
    private Provider provider;
    private static Class cl;
    private static final Class[] getImplParams;
    private static Method getImplMethod;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$security$Provider;

    protected KeyInfoFactory() {
    }

    public static KeyInfoFactory getInstance(String string) {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        return KeyInfoFactory.findInstance(string, null);
    }

    private static KeyInfoFactory findInstance(String string, Provider provider) {
        if (getImplMethod == null) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type");
        }
        Object[] objectArray = null;
        try {
            objectArray = (Object[])getImplMethod.invoke(null, string, "KeyInfoFactory", provider);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type", invocationTargetException);
        }
        KeyInfoFactory keyInfoFactory = (KeyInfoFactory)objectArray[0];
        keyInfoFactory.mechanismType = string;
        keyInfoFactory.provider = (Provider)objectArray[1];
        return keyInfoFactory;
    }

    public static KeyInfoFactory getInstance(String string, Provider provider) {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        return KeyInfoFactory.findInstance(string, provider);
    }

    public static KeyInfoFactory getInstance(String string, String string2) throws NoSuchProviderException {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (string2 == null) {
            throw new NullPointerException("provider cannot be null");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("cannot find provider named " + string2);
        }
        return KeyInfoFactory.findInstance(string, provider);
    }

    public static KeyInfoFactory getInstance() {
        return KeyInfoFactory.getInstance("DOM");
    }

    public final String getMechanismType() {
        return this.mechanismType;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract KeyInfo newKeyInfo(List var1);

    public abstract KeyInfo newKeyInfo(List var1, String var2);

    public abstract KeyName newKeyName(String var1);

    public abstract KeyValue newKeyValue(PublicKey var1) throws KeyException;

    public abstract PGPData newPGPData(byte[] var1);

    public abstract PGPData newPGPData(byte[] var1, byte[] var2, List var3);

    public abstract PGPData newPGPData(byte[] var1, List var2);

    public abstract RetrievalMethod newRetrievalMethod(String var1);

    public abstract RetrievalMethod newRetrievalMethod(String var1, String var2, List var3);

    public abstract X509Data newX509Data(List var1);

    public abstract X509IssuerSerial newX509IssuerSerial(String var1, BigInteger var2);

    public abstract boolean isFeatureSupported(String var1);

    public abstract URIDereferencer getURIDereferencer();

    public abstract KeyInfo unmarshalKeyInfo(XMLStructure var1) throws MarshalException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        getImplParams = new Class[]{class$java$lang$String == null ? (class$java$lang$String = KeyInfoFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = KeyInfoFactory.class$("java.lang.String")) : class$java$lang$String, class$java$security$Provider == null ? (class$java$security$Provider = KeyInfoFactory.class$("java.security.Provider")) : class$java$security$Provider};
        try {
            cl = Class.forName("javax.xml.crypto.dsig.XMLDSigSecurity");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        getImplMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    method = cl.getDeclaredMethod("getImpl", getImplParams);
                    if (method != null) {
                        ((AccessibleObject)method).setAccessible(true);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return method;
            }
        });
    }
}

