/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.scram.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ScramMechanism {
    SCRAM_SHA_256(1, "SHA-256", "HmacSHA256", 4096, 16384),
    SCRAM_SHA_512(2, "SHA-512", "HmacSHA512", 4096, 16384);

    private final byte type;
    private final String mechanismName;
    private final String hashAlgorithm;
    private final String macAlgorithm;
    private final int minIterations;
    private final int maxIterations;
    private static final Map<String, ScramMechanism> MECHANISMS_MAP;

    private ScramMechanism(byte type, String hashAlgorithm, String macAlgorithm, int minIterations, int maxIterations) {
        this.type = type;
        this.mechanismName = "SCRAM-" + hashAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.macAlgorithm = macAlgorithm;
        this.minIterations = minIterations;
        this.maxIterations = maxIterations;
    }

    public final String mechanismName() {
        return this.mechanismName;
    }

    public String hashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String macAlgorithm() {
        return this.macAlgorithm;
    }

    public int minIterations() {
        return this.minIterations;
    }

    public int maxIterations() {
        return this.maxIterations;
    }

    public static ScramMechanism forMechanismName(String mechanismName) {
        return MECHANISMS_MAP.get(mechanismName);
    }

    public static Collection<String> mechanismNames() {
        return MECHANISMS_MAP.keySet();
    }

    public static boolean isScram(String mechanismName) {
        return MECHANISMS_MAP.containsKey(mechanismName);
    }

    public byte type() {
        return this.type;
    }

    static {
        HashMap<String, ScramMechanism> map = new HashMap<String, ScramMechanism>();
        for (ScramMechanism mech : ScramMechanism.values()) {
            map.put(mech.mechanismName, mech);
        }
        MECHANISMS_MAP = Collections.unmodifiableMap(map);
    }
}

