/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.annotation;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.annotation.AnnotationValidator;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class LinkAnnotationValidator
extends AnnotationValidator {
    protected PDAnnotationLink pdLink = null;

    public LinkAnnotationValidator(PreflightContext ctx, COSDictionary annotDictionary) {
        super(ctx, annotDictionary);
        this.pdLink = new PDAnnotationLink(annotDictionary);
        this.pdAnnot = this.pdLink;
    }

    @Override
    public boolean validate() throws ValidationException {
        boolean isValid = super.validate();
        isValid = this.checkDest() && isValid;
        return isValid;
    }

    protected boolean checkDest() {
        try {
            if (this.pdLink.getDestination() != null && this.pdLink.getAction() != null) {
                this.ctx.addValidationError(new ValidationResult.ValidationError("5.2.4", "Dest can't be used due to A element"));
                return false;
            }
            COSDictionary dict = this.pdLink.getCOSObject();
            COSBase dest = dict.getDictionaryObject(COSName.DEST);
            if (dest != null) {
                ContextHelper.validateElement(this.ctx, dest, "destination-process");
            }
        }
        catch (IOException e) {
            this.ctx.addValidationError(new ValidationResult.ValidationError("5.3.3", e.getMessage(), e));
            return false;
        }
        return true;
    }
}

