/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.common.XThreadInputStream;
import org.apache.manifoldcf.connectorcommon.extmimemap.ExtensionMimeMap;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.hdfs.HDFSSession;
import org.apache.manifoldcf.crawler.connectors.hdfs.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.ui.util.Encoder;

public class HDFSRepositoryConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: FileConnector.java 995085 2010-09-08 15:13:38Z kwright $";
    protected static final String ACTIVITY_READ = "read document";
    protected static final String RELATIONSHIP_CHILD = "child";
    protected static final String[] activitiesList = new String[]{"read document"};
    protected String nameNodeProtocol = null;
    protected String nameNodeHost = null;
    protected String nameNodePort = null;
    protected String user = null;
    protected HDFSSession session = null;
    protected long lastSessionFetch = -1L;
    protected static final long timeToRelease = 300000L;

    public int getConnectorModel() {
        return 10;
    }

    public String[] getRelationshipTypes() {
        return new String[]{RELATIONSHIP_CHILD};
    }

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.nameNodeHost};
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.nameNodeProtocol = configParams.getParameter("namenodeprotocol");
        if (this.nameNodeProtocol == null) {
            this.nameNodeProtocol = "hdfs";
        }
        this.nameNodeHost = configParams.getParameter("namenodehost");
        this.nameNodePort = configParams.getParameter("namenodeport");
        this.user = configParams.getParameter("user");
    }

    public void disconnect() throws ManifoldCFException {
        this.closeSession();
        this.user = null;
        this.nameNodeProtocol = null;
        this.nameNodeHost = null;
        this.nameNodePort = null;
        super.disconnect();
    }

    protected HDFSSession getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            if (StringUtils.isEmpty((String)this.nameNodeProtocol)) {
                throw new ManifoldCFException("Parameter namenodeprotocol required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("HDFS: NameNodeProtocol = '" + this.nameNodeProtocol + "'"));
            }
            if (StringUtils.isEmpty((String)this.nameNodeHost)) {
                throw new ManifoldCFException("Parameter namenodehost required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("HDFS: NameNodeHost = '" + this.nameNodeHost + "'"));
            }
            if (StringUtils.isEmpty((String)this.nameNodePort)) {
                throw new ManifoldCFException("Parameter namenodeport required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("HDFS: NameNodePort = '" + this.nameNodePort + "'"));
            }
            if (StringUtils.isEmpty((String)this.user)) {
                throw new ManifoldCFException("Parameter user required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("HDFS: User = '" + this.user + "'"));
            }
            String nameNode = this.nameNodeProtocol + "://" + this.nameNodeHost + ":" + this.nameNodePort;
            GetSessionThread t = new GetSessionThread(nameNode, this.user);
            try {
                t.start();
                t.finishUp();
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (SocketTimeoutException e) {
                HDFSRepositoryConnector.handleIOException(e);
            }
            catch (InterruptedIOException e) {
                t.interrupt();
                HDFSRepositoryConnector.handleIOException(e);
            }
            catch (URISyntaxException e) {
                HDFSRepositoryConnector.handleURISyntaxException(e);
            }
            catch (IOException e) {
                HDFSRepositoryConnector.handleIOException(e);
            }
            this.session = t.getResult();
        }
        this.lastSessionFetch = System.currentTimeMillis();
        return this.session;
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            this.closeSession();
        }
    }

    protected void closeSession() throws ManifoldCFException {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (InterruptedIOException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
            }
            catch (IOException e) {
                Logging.connectors.warn((Object)("HDFS: Error closing connection: " + e.getMessage()), (Throwable)e);
            }
            finally {
                this.session = null;
                this.lastSessionFetch = -1L;
            }
        }
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        String path = "";
        for (int i = 0; i < spec.getChildCount(); ++i) {
            FileStatus fileStatus;
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals("startpoint") || !(fileStatus = this.getObject(new Path(path = sn.getAttributeValue("path")))).isDirectory()) continue;
            activities.addSeedDocument(fileStatus.getPath().toUri().toString());
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        for (String documentIdentifier : documentIdentifiers) {
            FileStatus fileStatus = this.getObject(new Path(documentIdentifier));
            if (fileStatus != null) {
                String versionString;
                long lastModified;
                boolean isDirectory = fileStatus.isDirectory();
                if (isDirectory) {
                    lastModified = fileStatus.getModificationTime();
                    versionString = new Long(lastModified).toString();
                    if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
                    String entityReference = documentIdentifier;
                    FileStatus[] fileStatuses = this.getChildren(fileStatus.getPath());
                    if (fileStatuses == null) continue;
                    for (int j = 0; j < fileStatuses.length; ++j) {
                        FileStatus fs = fileStatuses[j++];
                        String canonicalPath = fs.getPath().toString();
                        if (!HDFSRepositoryConnector.checkInclude(this.session.getUri().toString(), fs, canonicalPath, spec)) continue;
                        activities.addDocumentReference(canonicalPath, documentIdentifier, RELATIONSHIP_CHILD);
                    }
                    continue;
                }
                lastModified = fileStatus.getModificationTime();
                StringBuilder sb = new StringBuilder();
                String nameNode = this.nameNodeProtocol + "://" + this.nameNodeHost + ":" + this.nameNodePort;
                String convertPath = HDFSRepositoryConnector.findConvertPath(nameNode, spec, fileStatus.getPath());
                if (convertPath != null) {
                    sb.append("+");
                    HDFSRepositoryConnector.pack((StringBuilder)sb, (String)convertPath, (char)'+');
                } else {
                    sb.append("-");
                }
                sb.append(new Long(lastModified).toString());
                versionString = sb.toString();
                long startTime = System.currentTimeMillis();
                String errorCode = null;
                Object errorDesc = null;
                long fileSize = 0L;
                if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
                if (!HDFSRepositoryConnector.checkIngest(this.session.getUri().toString(), fileStatus, spec)) {
                    activities.noDocument(documentIdentifier, versionString);
                    continue;
                }
                long fileLength = fileStatus.getLen();
                String fileName = fileStatus.getPath().getName();
                String mimeType = HDFSRepositoryConnector.mapExtensionToMimeType(fileStatus.getPath().getName());
                Date modifiedDate = new Date(fileStatus.getModificationTime());
                try {
                    String uri = convertPath != null ? HDFSRepositoryConnector.convertToWGETURI(convertPath) : fileStatus.getPath().toUri().toString();
                    if (!activities.checkLengthIndexable(fileLength)) {
                        errorCode = "EXCLUDEDLENGTH";
                        errorDesc = "Excluding document because of file length ('" + fileLength + "')";
                        activities.noDocument(documentIdentifier, versionString);
                        continue;
                    }
                    if (!activities.checkURLIndexable(uri)) {
                        errorCode = "EXCLUDEDURL";
                        errorDesc = "Excluding document because of URL ('" + uri + "')";
                        activities.noDocument(documentIdentifier, versionString);
                        continue;
                    }
                    if (!activities.checkMimeTypeIndexable(mimeType)) {
                        errorCode = "EXCLUDEDMIMETYPE";
                        errorDesc = "Excluding document because of mime type (" + mimeType + ")";
                        activities.noDocument(documentIdentifier, versionString);
                        continue;
                    }
                    if (!activities.checkDateIndexable(modifiedDate)) {
                        errorCode = "EXCLUDEDDATE";
                        errorDesc = "Excluding document because of date (" + String.valueOf(modifiedDate) + ")";
                        activities.noDocument(documentIdentifier, versionString);
                        continue;
                    }
                    RepositoryDocument data = new RepositoryDocument();
                    data.setFileName(fileName);
                    data.setMimeType(mimeType);
                    data.setModifiedDate(modifiedDate);
                    data.addField("uri", uri);
                    BackgroundStreamThread t = new BackgroundStreamThread(this.getSession(), new Path(documentIdentifier));
                    try {
                        t.start();
                        boolean wasInterrupted = false;
                        try (InputStream is = t.getSafeInputStream();){
                            data.setBinary(is, fileSize);
                            activities.ingestDocumentWithException(documentIdentifier, versionString, uri, data);
                        }
                        catch (SocketTimeoutException e) {
                            throw e;
                        }
                        catch (InterruptedIOException e) {
                            wasInterrupted = true;
                            throw e;
                        }
                        catch (ManifoldCFException e) {
                            if (e.getErrorCode() == 2) {
                                wasInterrupted = true;
                            }
                            throw e;
                        }
                        finally {
                            if (!wasInterrupted) {
                                t.finishUp();
                            }
                        }
                        errorCode = "OK";
                        fileSize = fileStatus.getLen();
                        continue;
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (SocketTimeoutException e) {
                        errorCode = "IOERROR";
                        errorDesc = e.getMessage();
                        HDFSRepositoryConnector.handleIOException(e);
                        continue;
                    }
                    catch (InterruptedIOException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        errorCode = "IOERROR";
                        errorDesc = e.getMessage();
                        HDFSRepositoryConnector.handleIOException(e);
                        continue;
                    }
                }
                finally {
                    if (errorCode != null) {
                        activities.recordActivity(new Long(startTime), ACTIVITY_READ, new Long(fileSize), documentIdentifier, errorCode, (String)errorDesc, null);
                    }
                }
            }
            activities.deleteDocument(documentIdentifier);
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "HDFSRepositoryConnector.ServerTabName"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfigForSave()\n{\n  if (editconnection.namenodehost.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "HDFSRepositoryConnector.NameNodeHostCannotBeNull") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "HDFSRepositoryConnector.ServerTabName") + "\");\n    editconnection.namenodehost.focus();\n    return false;\n  }\n  if (editconnection.namenodeport.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "HDFSRepositoryConnector.NameNodePortCannotBeNull") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "HDFSRepositoryConnector.ServerTabName") + "\");\n    editconnection.namenodeport.focus();\n    return false;\n  }\n  if (!isInteger(editconnection.namenodeport.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "HDFSRepositoryConnector.NameNodePortMustBeAnInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "HDFSRepositoryConnector.ServerTabName") + "\");\n    editconnection.namenodeport.focus();\n    return false;\n  }\n  if (editconnection.user.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "HDFSRepositoryConnector.UserCannotBeNull") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "HDFSRepositoryConnector.ServerTabName") + "\");\n    editconnection.user.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String user;
        String nameNodePort;
        String nameNodeHost;
        String nameNodeProtocol = parameters.getParameter("namenodeprotocol");
        if (nameNodeProtocol == null) {
            nameNodeProtocol = "hdfs";
        }
        if ((nameNodeHost = parameters.getParameter("namenodehost")) == null) {
            nameNodeHost = "localhost";
        }
        if ((nameNodePort = parameters.getParameter("namenodeport")) == null) {
            nameNodePort = "9000";
        }
        if ((user = parameters.getParameter("user")) == null) {
            user = "";
        }
        if (tabName.equals(Messages.getString(locale, "HDFSRepositoryConnector.ServerTabName"))) {
            out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.NameNodeProtocol") + "</nobr></td>\n    <td class=\"value\">\n      <select name=\"namenodeprotocol\" size=\"2\">\n        <option value=\"file\"" + (nameNodeProtocol.equals("file") ? " selected=\"true\"" : "") + ">file</option>\n        <option value=\"ftp\"" + (nameNodeProtocol.equals("ftp") ? " selected=\"true\"" : "") + ">ftp</option>\n        <option value=\"har\"" + (nameNodeProtocol.equals("har") ? " selected=\"true\"" : "") + ">har</option>\n        <option value=\"hdfs\"" + (nameNodeProtocol.equals("hdfs") ? " selected=\"true\"" : "") + ">hdfs</option>\n        <option value=\"s3\"" + (nameNodeProtocol.equals("s3") ? " selected=\"true\"" : "") + ">s3</option>\n        <option value=\"s3n\"" + (nameNodeProtocol.equals("s3n") ? " selected=\"true\"" : "") + ">s3n</option>\n        <option value=\"viewfs\"" + (nameNodeProtocol.equals("viewfs") ? " selected=\"true\"" : "") + ">viewfs</option>\n      </select>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.NameNodeHost") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"namenodehost\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)nameNodeHost) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.NameNodePort") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"namenodeport\" type=\"text\" size=\"5\" value=\"" + Encoder.attributeEscape((String)nameNodePort) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.User") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"user\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)user) + "\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"namenodeprotocol\" value=\"" + Encoder.attributeEscape((String)nameNodeProtocol) + "\"/>\n<input type=\"hidden\" name=\"namenodehost\" value=\"" + Encoder.attributeEscape((String)nameNodeHost) + "\"/>\n<input type=\"hidden\" name=\"namenodeport\" value=\"" + Encoder.attributeEscape((String)nameNodePort) + "\"/>\n<input type=\"hidden\" name=\"user\" value=\"" + Encoder.attributeEscape((String)user) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String user;
        String nameNodePort;
        String nameNodeHost;
        String nameNodeProtocol = variableContext.getParameter("namenodeprotocol");
        if (nameNodeProtocol != null) {
            parameters.setParameter("namenodeprotocol", nameNodeProtocol);
        }
        if ((nameNodeHost = variableContext.getParameter("namenodehost")) != null) {
            parameters.setParameter("namenodehost", nameNodeHost);
        }
        if ((nameNodePort = variableContext.getParameter("namenodeport")) != null) {
            parameters.setParameter("namenodeport", nameNodePort);
        }
        if ((user = variableContext.getParameter("user")) != null) {
            parameters.setParameter("user", user);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        String nameNodeProtocol = parameters.getParameter("namenodeprotocol");
        if (nameNodeProtocol == null) {
            nameNodeProtocol = "hdfs";
        }
        String nameNodeHost = parameters.getParameter("namenodehost");
        String nameNodePort = parameters.getParameter("namenodeport");
        String user = parameters.getParameter("user");
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.NameNodeProtocol") + "</nobr></td>\n    <td class=\"value\">\n" + Encoder.attributeEscape((String)nameNodeProtocol) + "</td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.NameNodeHost") + "</nobr></td>\n    <td class=\"value\">\n" + Encoder.attributeEscape((String)nameNodeHost) + "</td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.NameNodePort") + "</nobr></td>\n    <td class=\"value\">\n" + Encoder.attributeEscape((String)nameNodePort) + "</td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.User") + "</nobr></td>\n    <td class=\"value\">\n" + Encoder.attributeEscape((String)user) + "</td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "HDFSRepositoryConnector.Paths"));
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        out.print("<script type=\"text/javascript\">\n<!--\n\nfunction " + seqPrefix + "SpecOp(n, opValue, anchorvalue)\n{\n  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n  postFormSetAnchor(anchorvalue);\n}\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        if (tabName.equals(Messages.getString(locale, "HDFSRepositoryConnector.Paths")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"3\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.Paths2") + "</nobr></td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.RootPath") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.ConvertToURI") + "<br/>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.ConvertToURIExample") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.Rules") + "</nobr></td>\n        </tr>\n");
            int i = 0;
            int k = 0;
            while (i < ds.getChildCount()) {
                int j;
                SpecificationNode sn;
                if (!(sn = ds.getChild(i++)).getType().equals("startpoint")) continue;
                String pathDescription = "_" + Integer.toString(k);
                String pathOpName = seqPrefix + "specop" + pathDescription;
                String path = sn.getAttributeValue("path");
                String convertToURIString = sn.getAttributeValue("converttouri");
                boolean convertToURI = false;
                if (convertToURIString != null && convertToURIString.equals("true")) {
                    convertToURI = true;
                }
                out.print("        <tr class=\"" + (k % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n          <td class=\"formcolumncell\">\n            <input type=\"hidden\" name=\"" + pathOpName + "\" value=\"\"/>\n            <input type=\"hidden\" name=\"" + seqPrefix + "specpath" + pathDescription + "\" value=\"" + Encoder.attributeEscape((String)sn.getAttributeValue("path")) + "\"/>\n            <a name=\"" + seqPrefix + "path_" + Integer.toString(k) + "\">\n              <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "HDFSRepositoryConnector.Delete") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + pathOpName + "\",\"Delete\",\"" + seqPrefix + "path_" + Integer.toString(k) + "\")' alt=\"" + Messages.getAttributeString(locale, "HDFSRepositoryConnector.DeletePath") + Integer.toString(k) + "\"/>\n            </a>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>\n              " + Encoder.bodyEscape((String)path) + " \n            </nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <input type=\"hidden\" name=\"" + seqPrefix + "converttouri" + pathDescription + "\" value=\"" + (convertToURI ? "true" : "false") + "\">\n            <nobr>\n              " + (convertToURI ? Messages.getBodyString(locale, "HDFSRepositoryConnector.Yes") : Messages.getBodyString(locale, "HDFSRepositoryConnector.No")) + " \n            </nobr>\n          </td>\n          <td class=\"boxcell\">\n            <input type=\"hidden\" name=\"" + seqPrefix + "specchildcount" + pathDescription + "\" value=\"" + Integer.toString(sn.getChildCount()) + "\"/>\n            <table class=\"formtable\">\n              <tr class=\"formheaderrow\">\n                <td class=\"formcolumnheader\"></td>\n                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.IncludeExclude") + "</nobr></td>\n                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.FileDirectory") + "</nobr></td>\n                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.Match") + "</nobr></td>\n              </tr>\n");
                for (j = 0; j < sn.getChildCount(); ++j) {
                    SpecificationNode excludeNode = sn.getChild(j);
                    String instanceDescription = "_" + Integer.toString(k) + "_" + Integer.toString(j);
                    String instanceOpName = seqPrefix + "specop" + instanceDescription;
                    String nodeFlavor = excludeNode.getType();
                    String nodeType = excludeNode.getAttributeValue("type");
                    String nodeMatch = excludeNode.getAttributeValue("match");
                    out.print("              <tr class=\"evenformrow\">\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "HDFSRepositoryConnector.InsertHere") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + seqPrefix + "specop" + instanceDescription + "\",\"Insert Here\",\"" + seqPrefix + "match_" + Integer.toString(k) + "_" + Integer.toString(j + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "HDFSRepositoryConnector.InsertNewMatchForPath") + Integer.toString(k) + " before position #" + Integer.toString(j) + "\"/>\n                  </nobr>\n                </td>\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    <select name=\"" + seqPrefix + "specflavor" + instanceDescription + "\">\n                      <option value=\"include\">" + Messages.getBodyString(locale, "HDFSRepositoryConnector.include") + "</option>\n                      <option value=\"exclude\">" + Messages.getBodyString(locale, "HDFSRepositoryConnector.exclude") + "</option>\n                    </select>\n                  </nobr>\n                </td>\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    <select name=\"" + seqPrefix + "spectype" + instanceDescription + "\">\n                      <option value=\"file\">" + Messages.getBodyString(locale, "HDFSRepositoryConnector.File") + "</option>\n                      <option value=\"directory\">" + Messages.getBodyString(locale, "HDFSRepositoryConnector.Directory") + "</option>\n                    </select>\n                  </nobr>\n                </td>\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    <input type=\"text\" size=\"10\" name=\"" + seqPrefix + "specmatch" + instanceDescription + "\" value=\"\"/>\n                  </nobr>\n                </td>\n              </tr>\n              <tr class=\"oddformrow\">\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    <input type=\"hidden\" name=\"" + instanceOpName + "\" value=\"\"/>\n                    <input type=\"hidden\" name=\"" + seqPrefix + "specfl" + instanceDescription + "\" value=\"" + nodeFlavor + "\"/>\n                    <input type=\"hidden\" name=\"" + seqPrefix + "specty" + instanceDescription + "\" value=\"" + nodeType + "\"/>\n                    <input type=\"hidden\" name=\"" + seqPrefix + "specma" + instanceDescription + "\" value=\"" + Encoder.attributeEscape((String)nodeMatch) + "\"/>\n                    <a name=\"" + seqPrefix + "match_" + Integer.toString(k) + "_" + Integer.toString(j) + "\">\n                      <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "HDFSRepositoryConnector.Delete") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + instanceOpName + "\",\"Delete\",\"" + seqPrefix + "match_" + Integer.toString(k) + "_" + Integer.toString(j) + "\")' alt=\"" + Messages.getAttributeString(locale, "HDFSRepositoryConnector.DeletePath") + Integer.toString(k) + ", match spec #" + Integer.toString(j) + "\"/>\n                    </a>\n                  </nobr>\n                </td>\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    " + nodeFlavor + "\n                  </nobr>\n                </td>\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    " + nodeType + "\n                  </nobr>\n                </td>\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    " + Encoder.bodyEscape((String)nodeMatch) + "\n                  </nobr>\n                </td>\n              </tr>\n");
                }
                if (j == 0) {
                    out.print("              <tr class=\"formrow\"><td class=\"formcolumnmessage\" colspan=\"4\">" + Messages.getBodyString(locale, "HDFSRepositoryConnector.NoRulesDefined") + "</td></tr>\n");
                }
                out.print("              <tr class=\"formrow\"><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n              <tr class=\"formrow\">\n                <td class=\"formcolumncell\">\n                  <a name=\"" + seqPrefix + "match_" + Integer.toString(k) + "_" + Integer.toString(j) + "\">\n                    <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "HDFSRepositoryConnector.Add") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + pathOpName + "\",\"Add\",\"" + seqPrefix + "match_" + Integer.toString(k) + "_" + Integer.toString(j + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "HDFSRepositoryConnector.AddNewMatchForPath") + Integer.toString(k) + "\"/>\n                  </a>\n                </td>\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    <select name=\"" + seqPrefix + "specflavor" + pathDescription + "\">\n                      <option value=\"include\">" + Messages.getBodyString(locale, "HDFSRepositoryConnector.include") + "</option>\n                      <option value=\"exclude\">" + Messages.getBodyString(locale, "HDFSRepositoryConnector.exclude") + "</option>\n                    </select>\n                  </nobr>\n                </td>\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    <select name=\"" + seqPrefix + "spectype" + pathDescription + "\">\n                      <option value=\"file\">" + Messages.getBodyString(locale, "HDFSRepositoryConnector.File") + "</option>\n                      <option value=\"directory\">" + Messages.getBodyString(locale, "HDFSRepositoryConnector.Directory") + "</option>\n                    </select>\n                  </nobr>\n                </td>\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    <input type=\"text\" size=\"10\" name=\"" + seqPrefix + "specmatch" + pathDescription + "\" value=\"\"/>\n                  </nobr>\n                </td>\n              </tr>\n            </table>\n          </td>\n        </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("        <tr class=\"formrow\"><td class=\"formcolumnmessage\" colspan=\"4\">" + Messages.getBodyString(locale, "HDFSRepositoryConnector.NoDocumentsSpecified") + "</td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td class=\"lightseparator\" colspan=\"4\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <nobr>\n              <a name=\"" + seqPrefix + "path_" + Integer.toString(k) + "\">\n                <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "HDFSRepositoryConnector.Add") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + seqPrefix + "specop\",\"Add\",\"" + seqPrefix + "path_" + Integer.toString(i + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "HDFSRepositoryConnector.AddNewPath") + "\"/>\n                <input type=\"hidden\" name=\"" + seqPrefix + "pathcount\" value=\"" + Integer.toString(k) + "\"/>\n                <input type=\"hidden\" name=\"" + seqPrefix + "specop\" value=\"\"/>\n              </a>\n            </nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>\n              <input type=\"text\" size=\"30\" name=\"" + seqPrefix + "specpath\" value=\"\"/>\n            </nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>\n              <input name=\"" + seqPrefix + "converttouri\" type=\"checkbox\" value=\"true\"/>\n            </nobr>\n          </td>\n          <td class=\"formcolumncell\">\n          </td>\n        </tr>\n      </table>\n    </td>\n  </tr>\n</table>\n");
        } else {
            int i = 0;
            int k = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn;
                if (!(sn = ds.getChild(i++)).getType().equals("startpoint")) continue;
                String pathDescription = "_" + Integer.toString(k);
                String path = sn.getAttributeValue("path");
                String convertToURIString = sn.getAttributeValue("converttouri");
                boolean convertToURI = false;
                if (convertToURIString != null && convertToURIString.equals("true")) {
                    convertToURI = true;
                }
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specpath" + pathDescription + "\" value=\"" + Encoder.attributeEscape((String)path) + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "converttouri" + pathDescription + "\" value=\"" + (convertToURI ? "true" : "false") + "\">\n<input type=\"hidden\" name=\"" + seqPrefix + "specchildcount" + pathDescription + "\" value=\"" + Integer.toString(sn.getChildCount()) + "\"/>\n");
                for (int j = 0; j < sn.getChildCount(); ++j) {
                    SpecificationNode excludeNode = sn.getChild(j);
                    String instanceDescription = "_" + Integer.toString(k) + "_" + Integer.toString(j);
                    String nodeFlavor = excludeNode.getType();
                    String nodeType = excludeNode.getAttributeValue("type");
                    String nodeMatch = excludeNode.getAttributeValue("match");
                    out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specfl" + instanceDescription + "\" value=\"" + nodeFlavor + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specty" + instanceDescription + "\" value=\"" + nodeType + "\"/>\n<input type=\"hidden\" name=\"" + seqPrefix + "specma" + instanceDescription + "\" value=\"" + Encoder.attributeEscape((String)nodeMatch) + "\"/>\n");
                }
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "pathcount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String x = variableContext.getParameter(seqPrefix + "pathcount");
        if (x != null) {
            ds.clearChildren();
            int pathCount = Integer.parseInt(x);
            int i = 0;
            int k = 0;
            while (i < pathCount) {
                String pathDescription = "_" + Integer.toString(i);
                String pathOpName = seqPrefix + "specop" + pathDescription;
                x = variableContext.getParameter(pathOpName);
                if (x != null && x.equals("Delete")) {
                    ++i;
                    continue;
                }
                String path = variableContext.getParameter(seqPrefix + "specpath" + pathDescription);
                String convertToURI = variableContext.getParameter(seqPrefix + "converttouri" + pathDescription);
                SpecificationNode node = new SpecificationNode("startpoint");
                node.setAttribute("path", path);
                if (convertToURI != null) {
                    node.setAttribute("converttouri", convertToURI);
                }
                String y = variableContext.getParameter(seqPrefix + "specchildcount" + pathDescription);
                int childCount = Integer.parseInt(y);
                int j = 0;
                int w = 0;
                while (j < childCount) {
                    SpecificationNode sn;
                    String match;
                    String type;
                    String flavor;
                    String instanceDescription = "_" + Integer.toString(i) + "_" + Integer.toString(j);
                    String instanceOp = seqPrefix + "specop" + instanceDescription;
                    String z = variableContext.getParameter(instanceOp);
                    if (z != null && z.equals("Delete")) {
                        ++j;
                        continue;
                    }
                    if (z != null && z.equals("Insert Here")) {
                        flavor = variableContext.getParameter(seqPrefix + "specflavor" + instanceDescription);
                        type = variableContext.getParameter(seqPrefix + "spectype" + instanceDescription);
                        match = variableContext.getParameter(seqPrefix + "specmatch" + instanceDescription);
                        sn = new SpecificationNode(flavor);
                        sn.setAttribute("type", type);
                        sn.setAttribute("match", match);
                        node.addChild(w++, (ConfigurationNode)sn);
                    }
                    flavor = variableContext.getParameter(seqPrefix + "specfl" + instanceDescription);
                    type = variableContext.getParameter(seqPrefix + "specty" + instanceDescription);
                    match = variableContext.getParameter(seqPrefix + "specma" + instanceDescription);
                    sn = new SpecificationNode(flavor);
                    sn.setAttribute("type", type);
                    sn.setAttribute("match", match);
                    node.addChild(w++, (ConfigurationNode)sn);
                    ++j;
                }
                if (x != null && x.equals("Add")) {
                    String match = variableContext.getParameter(seqPrefix + "specmatch" + pathDescription);
                    String type = variableContext.getParameter(seqPrefix + "spectype" + pathDescription);
                    String flavor = variableContext.getParameter(seqPrefix + "specflavor" + pathDescription);
                    SpecificationNode sn = new SpecificationNode(flavor);
                    sn.setAttribute("type", type);
                    sn.setAttribute("match", match);
                    node.addChild(w, (ConfigurationNode)sn);
                }
                ds.addChild(k++, (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "specop");
            if (op != null && op.equals("Add")) {
                String path = variableContext.getParameter(seqPrefix + "specpath");
                String convertToURI = variableContext.getParameter(seqPrefix + "converttouri");
                SpecificationNode node = new SpecificationNode("startpoint");
                node.setAttribute("path", path);
                if (convertToURI != null) {
                    node.setAttribute("converttouri", convertToURI);
                }
                SpecificationNode sn = new SpecificationNode("include");
                sn.setAttribute("type", "file");
                sn.setAttribute("match", "*");
                node.addChild(node.getChildCount(), (ConfigurationNode)sn);
                sn = new SpecificationNode("include");
                sn.setAttribute("type", "directory");
                sn.setAttribute("match", "*");
                node.addChild(node.getChildCount(), (ConfigurationNode)sn);
                ds.addChild(k, (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\">" + Messages.getAttributeString(locale, "HDFSRepositoryConnector.Paths2") + "</td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.RootPath") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.ConvertToURI") + "<br/>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.ConvertToURIExample") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.Rules") + "</nobr></td>\n        </tr>\n");
        int k = 0;
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (!sn.getType().equals("startpoint")) continue;
            String path = sn.getAttributeValue("path");
            String convertToURIString = sn.getAttributeValue("converttouri");
            boolean convertToURI = false;
            if (convertToURIString != null && convertToURIString.equals("true")) {
                convertToURI = true;
            }
            out.print("        <tr class=\"" + (k % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n          <td class=\"formcolumncell\">\n            <nobr>\n              " + Encoder.bodyEscape((String)path) + " \n            </nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>\n              " + (convertToURI ? Messages.getBodyString(locale, "HDFSRepositoryConnector.Yes") : Messages.getBodyString(locale, "HDFSRepositoryConnector.No")) + " \n            </nobr>\n          </td>\n          <td class=\"boxcell\">\n            <table class=\"formtable\">\n              <tr class=\"formheaderrow\">\n                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.IncludeExclude") + "</nobr></td>\n                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.FileDirectory") + "</nobr></td>\n                <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "HDFSRepositoryConnector.Match") + "</nobr></td>\n              </tr>\n");
            int l = 0;
            for (int j = 0; j < sn.getChildCount(); ++j) {
                SpecificationNode excludeNode = sn.getChild(j);
                String nodeFlavor = excludeNode.getType();
                String nodeType = excludeNode.getAttributeValue("type");
                String nodeMatch = excludeNode.getAttributeValue("match");
                out.print("              <tr class=\"" + (l % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    " + nodeFlavor + "\n                  </nobr>\n                </td>\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    " + nodeType + "\n                  </nobr>\n                </td>\n                <td class=\"formcolumncell\">\n                  <nobr>\n                    " + Encoder.bodyEscape((String)nodeMatch) + "\n                  </nobr>\n                </td>\n              </tr>\n");
                ++l;
            }
            if (l == 0) {
                out.print("              <tr><td class=\"formcolumnmessage\" colspan=\"3\">" + Messages.getBodyString(locale, "HDFSRepositoryConnector.NoRulesDefined") + "</td></tr>\n");
            }
            out.print("            </table>\n           </td>\n");
            out.print("        </tr>\n");
            ++k;
        }
        if (k == 0) {
            out.print("        <tr><td class=\"formcolumnmessage\" colspan=\"3\">" + Messages.getBodyString(locale, "HDFSRepositoryConnector.NoDocumentsSpecified") + "</td></tr>\n");
        }
        out.print("      </table>\n    </td>\n  </tr>\n");
        out.print("</table>\n");
    }

    protected static String convertToWGETURI(String path) throws ManifoldCFException {
        try {
            StringBuffer sb = new StringBuffer();
            String[] tmp = path.split("/", 3);
            String scheme = "";
            String host = "";
            Object other = "";
            scheme = tmp.length >= 1 ? tmp[0] : "hdfs";
            host = tmp.length >= 2 ? tmp[1] : "localhost:9000";
            other = tmp.length >= 3 ? "/" + tmp[2] : "/";
            return new URI(scheme + "://" + host + (String)other).toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad url: " + e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ManifoldCFException("Bad url: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static String findConvertPath(String nameNode, Specification spec, Path theFile) {
        String fullpath = theFile.toString();
        for (int j = 0; j < spec.getChildCount(); ++j) {
            SpecificationNode sn = spec.getChild(j);
            if (!sn.getType().equals("startpoint")) continue;
            Object path = sn.getAttributeValue("path");
            String convertToURI = sn.getAttributeValue("converttouri");
            if (((String)path).length() <= 0 || convertToURI == null || !convertToURI.equals("true")) continue;
            if (!((String)(path = nameNode + (String)path)).endsWith("/")) {
                path = (String)path + "/";
            }
            if (!fullpath.startsWith((String)path)) continue;
            return fullpath.substring(((String)path).length());
        }
        return null;
    }

    protected static String mapExtensionToMimeType(String fileName) {
        int dotIndex;
        int slashIndex = fileName.lastIndexOf("/");
        if (slashIndex != -1) {
            fileName = fileName.substring(slashIndex + 1);
        }
        if ((dotIndex = fileName.lastIndexOf(".")) == -1) {
            return null;
        }
        return ExtensionMimeMap.mapToMimeType((String)fileName.substring(dotIndex + 1).toLowerCase(Locale.ROOT));
    }

    protected static boolean checkInclude(String nameNode, FileStatus fileStatus, String fileName, Specification documentSpecification) throws ManifoldCFException {
        String filePart;
        String pathPart;
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("Checking whether to include file '" + fileName + "'"));
        }
        if (fileStatus.isDirectory()) {
            pathPart = fileName;
            filePart = null;
        } else {
            pathPart = fileStatus.getPath().getParent().toString();
            filePart = fileStatus.getPath().getName();
        }
        int i = 0;
        while (i < documentSpecification.getChildCount()) {
            int matchEnd;
            SpecificationNode sn;
            if (!(sn = documentSpecification.getChild(i++)).getType().equals("startpoint")) continue;
            String path = null;
            try {
                path = new URI(nameNode).resolve(sn.getAttributeValue("path")).toString();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Checking path '" + path + "' against canonical '" + pathPart + "'"));
            }
            if ((matchEnd = HDFSRepositoryConnector.matchSubPath(path, pathPart)) == -1) {
                if (!Logging.connectors.isDebugEnabled()) continue;
                Logging.connectors.debug((Object)("Match check '" + path + "' against canonical '" + pathPart + "' failed"));
                continue;
            }
            int j = 0;
            while (j < sn.getChildCount()) {
                int sourceIndex;
                String sourceMatch;
                SpecificationNode node = sn.getChild(j++);
                String flavor = node.getType();
                String match = node.getAttributeValue("match");
                String type = node.getAttributeValue("type");
                if (type.equals("file")) {
                    if (filePart == null) continue;
                    sourceMatch = filePart;
                    sourceIndex = 0;
                } else {
                    if (filePart != null) continue;
                    sourceMatch = pathPart;
                    sourceIndex = matchEnd;
                }
                if (flavor.equals("include")) {
                    if (!HDFSRepositoryConnector.checkMatch(sourceMatch, sourceIndex, match)) continue;
                    return true;
                }
                if (!flavor.equals("exclude") || !HDFSRepositoryConnector.checkMatch(sourceMatch, sourceIndex, match)) continue;
                return false;
            }
        }
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("Not including '" + fileName + "' because no matching rules"));
        }
        return false;
    }

    protected static boolean checkIngest(String nameNode, FileStatus fileStatus, Specification documentSpecification) throws ManifoldCFException {
        return true;
    }

    protected static int matchSubPath(String subPath, String fullPath) {
        if (subPath.length() > fullPath.length()) {
            return -1;
        }
        if (!fullPath.startsWith(subPath)) {
            return -1;
        }
        int rval = subPath.length();
        if (fullPath.length() == rval) {
            return rval;
        }
        char x = fullPath.charAt(rval);
        if (x == '/') {
            ++rval;
        }
        return rval;
    }

    protected static boolean checkMatch(String sourceMatch, int sourceIndex, String match) {
        boolean caseSensitive = true;
        return HDFSRepositoryConnector.processCheck(caseSensitive, sourceMatch, sourceIndex, match, 0);
    }

    protected static boolean processCheck(boolean caseSensitive, String sourceMatch, int sourceIndex, String match, int matchIndex) {
        while (true) {
            if (sourceMatch.length() == sourceIndex && match.length() == matchIndex) {
                return true;
            }
            if (match.length() == matchIndex) {
                return false;
            }
            if (sourceMatch.length() == sourceIndex) {
                if (match.charAt(matchIndex) != '*') {
                    return false;
                }
                ++matchIndex;
                continue;
            }
            char x = sourceMatch.charAt(sourceIndex);
            char y = match.charAt(matchIndex);
            if (!caseSensitive) {
                if (x >= 'A' && x <= 'Z') {
                    x = (char)(x + 32);
                }
                if (y >= 'A' && y <= 'Z') {
                    y = (char)(y + 32);
                }
            }
            if (y == '*') {
                return HDFSRepositoryConnector.processCheck(caseSensitive, sourceMatch, sourceIndex + 1, match, matchIndex) || HDFSRepositoryConnector.processCheck(caseSensitive, sourceMatch, sourceIndex, match, matchIndex + 1);
            }
            if (y != '?' && x != y) break;
            ++sourceIndex;
            ++matchIndex;
        }
        return false;
    }

    private static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        Logging.connectors.warn((Object)("HDFS: IO exception: " + e.getMessage()), (Throwable)e);
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    private static void handleURISyntaxException(URISyntaxException e) throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.error((Object)("HDFS: Bad namenode specification: " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException("Bad namenode specification: " + e.getMessage(), (Throwable)e);
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        CheckConnectionThread t = new CheckConnectionThread(this.getSession());
        try {
            t.start();
            t.finishUp();
            return;
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            HDFSRepositoryConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            HDFSRepositoryConnector.handleIOException(e);
        }
    }

    protected FileStatus[] getChildren(Path path) throws ManifoldCFException, ServiceInterruption {
        GetChildrenThread t = new GetChildrenThread(this.getSession(), path);
        try {
            t.start();
            t.finishUp();
            return t.getResult();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            HDFSRepositoryConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            HDFSRepositoryConnector.handleIOException(e);
        }
        catch (IOException e) {
            HDFSRepositoryConnector.handleIOException(e);
        }
        return null;
    }

    protected FileStatus getObject(Path path) throws ManifoldCFException, ServiceInterruption {
        GetObjectThread objt = new GetObjectThread(this.getSession(), path);
        try {
            objt.start();
            objt.finishUp();
            return objt.getResponse();
        }
        catch (InterruptedException e) {
            objt.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            HDFSRepositoryConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            objt.interrupt();
            HDFSRepositoryConnector.handleIOException(e);
        }
        catch (IOException e) {
            HDFSRepositoryConnector.handleIOException(e);
        }
        return null;
    }

    protected static class BackgroundStreamThread
    extends Thread {
        protected final HDFSSession session;
        protected final Path nodeId;
        protected boolean abortThread = false;
        protected Throwable responseException = null;
        protected InputStream sourceStream = null;
        protected XThreadInputStream threadStream = null;

        public BackgroundStreamThread(HDFSSession session, Path nodeId) {
            this.setDaemon(true);
            this.session = session;
            this.nodeId = nodeId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    BackgroundStreamThread backgroundStreamThread = this;
                    synchronized (backgroundStreamThread) {
                        if (!this.abortThread) {
                            this.sourceStream = this.session.getFSDataInputStream(this.nodeId);
                            this.threadStream = new XThreadInputStream(this.sourceStream);
                            this.notifyAll();
                        }
                    }
                    if (this.threadStream != null) {
                        this.threadStream.stuffQueue();
                    }
                }
                finally {
                    if (this.sourceStream != null) {
                        this.sourceStream.close();
                    }
                }
            }
            catch (Throwable e) {
                this.responseException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getSafeInputStream() throws InterruptedException, IOException {
            while (true) {
                BackgroundStreamThread backgroundStreamThread = this;
                synchronized (backgroundStreamThread) {
                    if (this.responseException != null) {
                        throw new IllegalStateException("Check for response before getting stream");
                    }
                    this.checkException(this.responseException);
                    if (this.threadStream != null) {
                        return this.threadStream;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishUp() throws InterruptedException, IOException {
            BackgroundStreamThread backgroundStreamThread = this;
            synchronized (backgroundStreamThread) {
                if (this.threadStream != null) {
                    this.threadStream.abort();
                }
                this.abortThread = true;
            }
            this.join();
            this.checkException(this.responseException);
        }

        protected synchronized void checkException(Throwable exception) throws IOException {
            if (exception != null) {
                Throwable e = exception;
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unhandled exception of type: " + e.getClass().getName(), e);
            }
        }
    }

    protected static class GetObjectThread
    extends Thread {
        protected final HDFSSession session;
        protected final Path nodeId;
        protected Throwable exception = null;
        protected FileStatus response = null;

        public GetObjectThread(HDFSSession session, Path nodeId) {
            this.setDaemon(true);
            this.session = session;
            this.nodeId = nodeId;
        }

        @Override
        public void run() {
            try {
                this.response = this.session.getObject(this.nodeId);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, IOException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                throw new RuntimeException("Unhandled exception of type: " + thr.getClass().getName(), thr);
            }
        }

        public FileStatus getResponse() {
            return this.response;
        }
    }

    protected class GetChildrenThread
    extends Thread {
        protected Throwable exception = null;
        protected FileStatus[] result = null;
        protected final HDFSSession session;
        protected final Path path;

        public GetChildrenThread(HDFSSession session, Path path) {
            this.session = session;
            this.path = path;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.result = this.session.listStatus(this.path);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, IOException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                throw new RuntimeException("Unhandled exception of type: " + thr.getClass().getName(), thr);
            }
        }

        public FileStatus[] getResult() {
            return this.result;
        }
    }

    protected static class GetSessionThread
    extends Thread {
        protected final String nameNode;
        protected final String user;
        protected Throwable exception = null;
        protected HDFSSession session;

        public GetSessionThread(String nameNode, String user) {
            this.nameNode = nameNode;
            this.user = user;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session = new HDFSSession(this.nameNode, this.user);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, IOException, URISyntaxException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof URISyntaxException) {
                    throw (URISyntaxException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }

        public HDFSSession getResult() {
            return this.session;
        }
    }

    protected static class CheckConnectionThread
    extends Thread {
        protected final HDFSSession session;
        protected Throwable exception = null;

        public CheckConnectionThread(HDFSSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.getRepositoryInfo();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, IOException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }
    }
}

