/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.List;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.QueuedDocument;

public class QueuedDocumentSet {
    public static final String _rcsid = "@(#)$Id: QueuedDocumentSet.java 988245 2010-08-23 18:39:35Z kwright $";
    protected final QueuedDocument[] documents;
    protected final IJobDescription jobDescription;
    protected final IRepositoryConnection connection;

    public QueuedDocumentSet(List<QueuedDocument> documents, IJobDescription jobDescription, IRepositoryConnection connection) {
        this.documents = documents.toArray(new QueuedDocument[0]);
        this.jobDescription = jobDescription;
        this.connection = connection;
    }

    public int getCount() {
        return this.documents.length;
    }

    public QueuedDocument getDocument(int index) {
        return this.documents[index];
    }

    public void beginProcessing(QueueTracker queueTracker) {
        int l = 0;
        while (l < this.documents.length) {
            QueuedDocument d = this.documents[l++];
            if (Logging.scheduling.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (String binName : d.getBinNames()) {
                    sb.append(binName).append(" ");
                }
                Logging.scheduling.debug((Object)("Handing document '" + d.getDocumentDescription().getDocumentIdentifier() + "' with bins [" + sb.toString() + "] to worker thread"));
            }
            queueTracker.beginProcessing(d.getBinNames());
        }
    }

    public void endProcessing(QueueTracker queueTracker) {
        int l = 0;
        while (l < this.documents.length) {
            QueuedDocument d = this.documents[l++];
            if (Logging.scheduling.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (String binName : d.getBinNames()) {
                    sb.append(binName).append(" ");
                }
                Logging.scheduling.debug((Object)("Worker thread done document '" + d.getDocumentDescription().getDocumentIdentifier() + "' with bins [" + sb.toString() + "]"));
            }
            queueTracker.endProcessing(d.getBinNames());
        }
    }

    public double calculateAssignmentRating(QueueTracker overlapCalculator) {
        double ratingAccumulator = 0.0;
        int i = 0;
        while (i < this.documents.length) {
            QueuedDocument d = this.documents[i++];
            double rating = overlapCalculator.calculateAssignmentRating(d.getBinNames(), this.connection);
            ratingAccumulator += rating;
        }
        return ratingAccumulator / (double)this.documents.length;
    }

    public IJobDescription getJobDescription() {
        return this.jobDescription;
    }

    public IRepositoryConnection getConnection() {
        return this.connection;
    }
}

