/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class HistoryCleanupThread
extends Thread {
    public static final String _rcsid = "@(#)$Id$";
    protected static final String historyCleanupIntervalProperty = "org.apache.manifoldcf.crawler.historycleanupinterval";
    protected final String processID;

    public HistoryCleanupThread(String processID) throws ManifoldCFException {
        this.processID = processID;
        this.setName("History cleanup thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(threadContext);
            long historyCleanupInterval = LockManagerFactory.getLongProperty((IThreadContext)threadContext, (String)historyCleanupIntervalProperty, (long)0L);
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    long currentTime = System.currentTimeMillis();
                    if (Logging.threads.isDebugEnabled()) {
                        Logging.threads.debug((Object)("History cleanup thread - removing old history at " + new Long(currentTime).toString()));
                    }
                    if (historyCleanupInterval > 0L && historyCleanupInterval < currentTime) {
                        connectionManager.cleanUpHistoryData(currentTime - historyCleanupInterval);
                    } else {
                        Logging.threads.debug((Object)" History cleanup thread did nothing because cleanup disabled");
                    }
                    ManifoldCF.sleep((long)3600000L);
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        Logging.threads.error((Object)("History thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    ManifoldCF.systemExit((int)1);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    ManifoldCF.systemExit((int)-200);
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                }
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("HistoryCleanupThread initialization error tossed: " + e.getMessage()), e);
            ManifoldCF.systemExit((int)-300);
        }
    }
}

