/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.net.URL;
import java.util.IdentityHashMap;

public class MsgLocalizationClassLoader {
    static final CallStack csi = new CallStack();
    private static final CallClimbingClassLoader MSG_LOCALIZATION_CLASS_LOADER = new CallClimbingClassLoader();

    public static URL getResource(String name) {
        return MSG_LOCALIZATION_CLASS_LOADER.getResource(name);
    }

    public static ClassLoader getMsgLocalizationClassLoader() {
        return MSG_LOCALIZATION_CLASS_LOADER;
    }

    public static Class<?> loadClass(String name) throws ClassNotFoundException {
        return MSG_LOCALIZATION_CLASS_LOADER.loadClass(name);
    }

    static class CallClimbingClassLoader
    extends ClassLoader {
        static final ThreadLocal<ClassLoader> originalTccl = new ThreadLocal();

        CallClimbingClassLoader() {
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            IdentityHashMap<ClassLoader, ClassLoader> alreadySearched = new IdentityHashMap<ClassLoader, ClassLoader>(7);
            Class<?>[] cs = new CallStack().getCallStack();
            for (int i = 3; i < cs.length; ++i) {
                Class<?> callingClass = cs[i];
                ClassLoader cl = callingClass.getClassLoader();
                if (null == cl) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                if (null != alreadySearched.get(cl)) continue;
                alreadySearched.put(cl, cl);
                Class<?> c = null;
                try {
                    c = cl.loadClass(name);
                    return c;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            try {
                ClassLoader cl = originalTccl.get();
                if (cl != null) {
                    return cl.loadClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }

        @Override
        public URL getResource(String name) {
            URL c;
            IdentityHashMap<ClassLoader, ClassLoader> alreadySearched = new IdentityHashMap<ClassLoader, ClassLoader>(7);
            Class<?>[] cs = new CallStack().getCallStack();
            for (int i = 3; i < cs.length; ++i) {
                Class<?> callingClass = cs[i];
                ClassLoader cl = callingClass.getClassLoader();
                if (null == cl) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                if (null != alreadySearched.get(cl)) continue;
                alreadySearched.put(cl, cl);
                URL c2 = cl.getResource(name);
                if (null == c2) continue;
                return c2;
            }
            ClassLoader cl = originalTccl.get();
            if (cl != null && null != (c = cl.getResource(name))) {
                return c;
            }
            return Thread.currentThread().getContextClassLoader().getResource(name);
        }
    }

    static class CallStack
    extends SecurityManager {
        CallStack() {
        }

        Class<?>[] getCallStack() {
            return this.getClassContext();
        }
    }
}

