/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.Precision;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PrecisionEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public PrecisionEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 2 value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value, Object value2) {
        if (null == value) {
            return null;
        }
        if (value instanceof List) {
            return ((List)value).stream().map(innerValue -> this.doWork(innerValue, (Object)((Number)value2).intValue())).collect(Collectors.toList());
        }
        if (value instanceof Matrix) {
            int p = ((Number)value2).intValue();
            Matrix matrix = (Matrix)value;
            double[][] data = matrix.getData();
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[i].length; ++j) {
                    data[i][j] = Precision.round((double)data[i][j], (int)p);
                }
            }
            return matrix;
        }
        return Precision.round((double)((Number)value).doubleValue(), (int)((Number)value2).intValue());
    }
}

