/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derby.jdbc.InternalDriver;

public class AutoloadedDriver
implements Driver {
    private static boolean _engineForcedDown = false;
    private static AutoloadedDriver _autoloadedDriver;
    private static Driver _driverModule;

    protected static void registerMe(AutoloadedDriver autoloadedDriver) {
        try {
            _autoloadedDriver = autoloadedDriver;
            DriverManager.registerDriver(_autoloadedDriver);
        }
        catch (SQLException sQLException) {
            String string = MessageService.getTextMessage("I026", sQLException.getMessage());
            throw new IllegalStateException(string);
        }
    }

    public boolean acceptsURL(String string) throws SQLException {
        return !_engineForcedDown && InternalDriver.embeddedDriverAcceptsURL(string);
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (!InternalDriver.embeddedDriverAcceptsURL(string)) {
            return null;
        }
        return AutoloadedDriver.getDriverModule().connect(string, properties);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return AutoloadedDriver.getDriverModule().getPropertyInfo(string, properties);
    }

    public int getMajorVersion() {
        try {
            return AutoloadedDriver.getDriverModule().getMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getMinorVersion() {
        try {
            return AutoloadedDriver.getDriverModule().getMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        try {
            return AutoloadedDriver.getDriverModule().jdbcCompliant();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    static Driver getDriverModule() throws SQLException {
        if (_engineForcedDown && _autoloadedDriver == null) {
            throw Util.generateCsSQLException("08006.C.8");
        }
        if (!AutoloadedDriver.isBooted()) {
            EmbeddedDriver.boot();
        }
        return _driverModule;
    }

    static void registerDriverModule(Driver driver) {
        _driverModule = driver;
        _engineForcedDown = false;
        try {
            if (_autoloadedDriver == null) {
                _autoloadedDriver = AutoloadedDriver.makeAutoloadedDriver();
                DriverManager.registerDriver(_autoloadedDriver);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static void unregisterDriverModule() {
        _engineForcedDown = true;
        try {
            if (InternalDriver.getDeregister() && _autoloadedDriver != null) {
                AutoloadedDriver.deregisterDriver(_autoloadedDriver);
                _autoloadedDriver = null;
            }
            InternalDriver.setDeregister(true);
            _driverModule = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void deregisterDriver(final AutoloadedDriver autoloadedDriver) throws SQLException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws SQLException {
                    DriverManager.deregisterDriver(autoloadedDriver);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (SQLException)privilegedActionException.getCause();
        }
        catch (AccessControlException accessControlException) {
            Monitor.logTextMessage("J137");
            Monitor.logThrowable(accessControlException);
        }
    }

    private static boolean isBooted() {
        return _driverModule != null;
    }

    private static AutoloadedDriver makeAutoloadedDriver() {
        try {
            return (AutoloadedDriver)Class.forName("org.apache.derby.jdbc.AutoloadedDriver40").newInstance();
        }
        catch (Throwable throwable) {
            return new AutoloadedDriver();
        }
    }

    static {
        try {
            Class.forName("org.apache.derby.jdbc.AutoloadedDriver40");
        }
        catch (Throwable throwable) {
            AutoloadedDriver.registerMe(new AutoloadedDriver());
        }
    }
}

