/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.fetchmail;

import jakarta.mail.Address;
import jakarta.mail.Flags;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.ParseException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.james.core.MailAddress;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.fetchmail.Account;
import org.apache.james.fetchmail.ProcessorAbstract;
import org.apache.james.server.core.MailImpl;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProcessor
extends ProcessorAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProcessor.class);
    private MimeMessage fieldMessageIn;
    private boolean fieldRecipientNotFound = false;
    private boolean fieldRemoteRecipient = true;
    private Boolean fieldRemoteReceivedHeaderInvalid;
    private boolean fieldUserUndefined = false;
    private Boolean fieldMaxMessageSizeExceeded;
    private static final String fieldRFC2822RECEIVEDHeaderFields = "from by via with id for ;";
    private boolean fieldBlacklistedRecipient = false;
    private String fieldRemoteDomain;
    private String fieldRemoteAddress;
    private String fieldRemoteHostName;
    private boolean fieldDefaultSenderLocalPart = false;
    private boolean fieldDefaultSenderDomainPart = false;
    private boolean fieldDefaultRemoteAddress = false;

    private MessageProcessor(Account account) {
        super(account);
    }

    MessageProcessor(MimeMessage messageIn, Account account) {
        this(account);
        this.setMessageIn(messageIn);
    }

    @Override
    public void process() throws MessagingException {
        Mail mail;
        LOGGER.debug("Attempting delivery of message with id. {}", (Object)this.getMessageIn().getMessageID());
        MailAddress intendedRecipient = this.getIntendedRecipient();
        this.setRecipientNotFound(null == intendedRecipient);
        if (this.isRecipientNotFound()) {
            if (this.isDeferRecipientNotFound()) {
                String messageID = this.getMessageIn().getMessageID();
                if (!this.getDeferredRecipientNotFoundMessageIDs().contains(messageID)) {
                    this.getDeferredRecipientNotFoundMessageIDs().add(messageID);
                    LOGGER.debug("Deferred processing of message for which the intended recipient could not be found. Message ID: {}", (Object)messageID);
                    return;
                }
                this.getDeferredRecipientNotFoundMessageIDs().remove(messageID);
                LOGGER.debug("Processing deferred message for which the intended recipient could not be found. Message ID: {}", (Object)messageID);
            }
            if (this.isRejectRecipientNotFound()) {
                this.rejectRecipientNotFound();
                return;
            }
            intendedRecipient = this.getRecipient();
            StringBuilder messageBuffer = new StringBuilder("Intended recipient not found. Using configured recipient as new envelope recipient - ");
            messageBuffer.append(intendedRecipient);
            messageBuffer.append('.');
            this.logStatusInfo(messageBuffer.toString());
        }
        this.setBlacklistedRecipient(this.isBlacklistedRecipient(intendedRecipient));
        this.setRemoteRecipient(!this.isLocalServer(intendedRecipient));
        try {
            this.setUserUndefined(!this.isLocalRecipient(intendedRecipient));
        }
        catch (UsersRepositoryException e) {
            throw new MessagingException("Unable to access USersRepository", (Exception)((Object)e));
        }
        if (this.isRejectBlacklisted() && this.isBlacklistedRecipient()) {
            this.rejectBlacklistedRecipient(intendedRecipient);
            return;
        }
        if (this.isRejectRemoteRecipient() && this.isRemoteRecipient()) {
            this.rejectRemoteRecipient(intendedRecipient);
            return;
        }
        if (this.isRejectUserUndefined() && this.isUserUndefined()) {
            this.rejectUserUndefined(intendedRecipient);
            return;
        }
        if (this.isRejectMaxMessageSizeExceeded() && this.isMaxMessageSizeExceeded().booleanValue()) {
            this.rejectMaxMessageSizeExceeded(this.getMessageIn().getSize());
            return;
        }
        if (this.isRejectRemoteReceivedHeaderInvalid() && this.isRemoteReceivedHeaderInvalid().booleanValue()) {
            this.rejectRemoteReceivedHeaderInvalid();
            return;
        }
        try {
            mail = this.createMail(this.createMessage(), intendedRecipient);
        }
        catch (ParseException ex) {
            this.handleParseException(ex);
            return;
        }
        catch (UnknownHostException ex) {
            this.handleUnknownHostException(ex);
            return;
        }
        this.addMailAttributes(mail);
        this.addErrorMessages(mail);
        if (this.isBouncing()) {
            this.handleBouncing(mail);
            return;
        }
        this.sendMail(mail);
    }

    protected void rejectRemoteRecipient(MailAddress recipient) throws MessagingException {
        if (!this.isLeaveRemoteRecipient()) {
            this.setMessageDeleted();
        }
        if (this.isMarkRemoteRecipientSeen()) {
            this.setMessageSeen();
        }
        StringBuilder messageBuffer = new StringBuilder("Rejected mail intended for remote recipient: ");
        messageBuffer.append(recipient);
        messageBuffer.append('.');
        this.logStatusInfo(messageBuffer.toString());
    }

    protected void rejectBlacklistedRecipient(MailAddress recipient) throws MessagingException {
        if (!this.isLeaveBlacklisted()) {
            this.setMessageDeleted();
        }
        if (this.isMarkBlacklistedSeen()) {
            this.setMessageSeen();
        }
        StringBuilder messageBuffer = new StringBuilder("Rejected mail intended for blacklisted recipient: ");
        messageBuffer.append(recipient);
        messageBuffer.append('.');
        this.logStatusInfo(messageBuffer.toString());
    }

    protected void rejectRecipientNotFound() throws MessagingException {
        Address[] allRecipients;
        if (!this.isLeaveRecipientNotFound()) {
            this.setMessageDeleted();
        }
        if (this.isMarkRecipientNotFoundSeen()) {
            this.setMessageSeen();
        }
        StringBuilder messageBuffer = new StringBuilder("Rejected mail for which a sole intended recipient could not be found.");
        messageBuffer.append(" Recipients: ");
        for (Address allRecipient : allRecipients = this.getMessageIn().getAllRecipients()) {
            messageBuffer.append(allRecipient);
            messageBuffer.append(' ');
        }
        messageBuffer.append('.');
        this.logStatusInfo(messageBuffer.toString());
    }

    protected void rejectUserUndefined(MailAddress recipient) throws MessagingException {
        if (!this.isLeaveUserUndefined()) {
            this.setMessageDeleted();
        }
        if (this.isMarkUserUndefinedSeen()) {
            this.setMessageSeen();
        }
        StringBuilder messageBuffer = new StringBuilder("Rejected mail intended for undefined user: ");
        messageBuffer.append(recipient);
        messageBuffer.append('.');
        this.logStatusInfo(messageBuffer.toString());
    }

    protected void rejectMaxMessageSizeExceeded(int messageSize) throws MessagingException {
        if (!this.isLeaveMaxMessageSizeExceeded()) {
            this.setMessageDeleted();
        }
        if (this.isMarkMaxMessageSizeExceededSeen()) {
            this.setMessageSeen();
        }
        StringBuilder messageBuffer = new StringBuilder("Rejected mail exceeding message size limit. Message size: ");
        messageBuffer.append(messageSize / 1024);
        messageBuffer.append("KB.");
        this.logStatusInfo(messageBuffer.toString());
    }

    protected void rejectRemoteReceivedHeaderInvalid() throws MessagingException {
        if (!this.isLeaveRemoteReceivedHeaderInvalid()) {
            this.setMessageDeleted();
        }
        if (this.isMarkRemoteReceivedHeaderInvalidSeen()) {
            this.setMessageSeen();
        }
        StringBuilder messageBuffer = new StringBuilder("Rejected mail with an invalid Received: header at index ");
        messageBuffer.append(this.getRemoteReceivedHeaderIndex());
        messageBuffer.append(".");
        this.logStatusInfo(messageBuffer.toString());
    }

    protected MimeMessage createMessage() throws MessagingException {
        MimeMessage messageOut = this.isMaxMessageSizeExceeded() != false ? this.createEmptyMessage() : new MimeMessage(this.getMessageIn());
        messageOut.addHeader("X-fetched-from", this.getFetchTaskName());
        return messageOut;
    }

    protected MimeMessage createEmptyMessage() throws MessagingException {
        MimeMessage messageOut = new MimeMessage(this.getSession());
        Enumeration headersInEnum = this.getMessageIn().getAllHeaderLines();
        while (headersInEnum.hasMoreElements()) {
            messageOut.addHeaderLine((String)headersInEnum.nextElement());
        }
        messageOut.setSubject(this.getMessageIn().getSubject());
        messageOut.setText("");
        messageOut.saveChanges();
        return messageOut;
    }

    protected Mail createMail(MimeMessage message, MailAddress recipient) throws MessagingException, UnknownHostException {
        MailImpl.Builder builder = MailImpl.builder().name(MailImpl.getId()).sender(this.getSender()).addRecipient(recipient).mimeMessage(message);
        try {
            builder.remoteAddr(this.getRemoteAddress());
            builder.remoteHost(this.getRemoteHostName());
            this.setDefaultRemoteAddress(false);
        }
        catch (UnknownHostException e) {
            if (!this.isRejectRemoteReceivedHeaderInvalid()) {
                builder.remoteAddr("127.0.0.1");
                builder.remoteHost("localhost");
                this.setDefaultRemoteAddress(true);
                this.logStatusInfo("Remote address could not be determined. Using localhost/127.0.0.1");
            }
            throw e;
        }
        MailImpl mail = builder.build();
        this.logMailCreation(mail);
        return mail;
    }

    private void logMailCreation(MailImpl mail) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder messageBuffer = new StringBuilder("Created mail with name: ");
            messageBuffer.append(mail.getName());
            messageBuffer.append(", sender: ");
            messageBuffer.append(mail.getMaybeSender());
            messageBuffer.append(", recipients: ");
            for (Object o : mail.getRecipients()) {
                messageBuffer.append(o);
                messageBuffer.append(' ');
            }
            messageBuffer.append(", remote address: ");
            messageBuffer.append(mail.getRemoteAddr());
            messageBuffer.append(", remote host name: ");
            messageBuffer.append(mail.getRemoteHost());
            messageBuffer.append('.');
            LOGGER.debug(messageBuffer.toString());
        }
    }

    protected MailAddress getSender() throws MessagingException {
        InternetAddress internetAddress;
        StringBuilder buffer;
        String from;
        try {
            from = ((InternetAddress)this.getMessageIn().getFrom()[0]).getAddress().trim();
            this.setDefaultSenderLocalPart(false);
        }
        catch (Exception ignored) {
            from = this.getDefaultLocalPart();
            this.setDefaultSenderLocalPart(true);
            buffer = new StringBuilder(32);
            buffer.append("Sender localpart is absent. Using default value (");
            buffer.append(this.getDefaultLocalPart());
            buffer.append(')');
            this.logStatusInfo(buffer.toString());
        }
        if (from.indexOf(64) < 0) {
            StringBuilder fromBuffer = new StringBuilder(from);
            fromBuffer.append('@');
            fromBuffer.append(this.getDefaultDomainName());
            internetAddress = new InternetAddress(fromBuffer.toString());
            this.setDefaultSenderDomainPart(true);
            buffer = new StringBuilder(32);
            buffer.append("Sender domain is absent. Using default value (");
            buffer.append(this.getDefaultDomainName());
            buffer.append(')');
            this.logStatusInfo(buffer.toString());
        } else {
            internetAddress = new InternetAddress(from);
            this.setDefaultSenderDomainPart(false);
        }
        return new MailAddress(internetAddress);
    }

    protected String computeRemoteDomain() throws MessagingException {
        boolean hasHeaders;
        StringBuilder domainBuffer = new StringBuilder();
        String[] headers = null;
        if (this.getRemoteReceivedHeaderIndex() > -1) {
            headers = this.getMessageIn().getHeader("Received");
        }
        boolean bl = hasHeaders = null != headers && headers.length > 0;
        if (hasHeaders) {
            int headerIndex;
            String headerTokens = " \n\r";
            int n = headerIndex = headers.length > this.getRemoteReceivedHeaderIndex() ? this.getRemoteReceivedHeaderIndex() : headers.length - 1;
            while (headerIndex >= 0 && domainBuffer.length() == 0) {
                StringTokenizer tokenizer = new StringTokenizer(headers[headerIndex], " \n\r");
                boolean inFrom = false;
                while (!inFrom && tokenizer.hasMoreTokens()) {
                    inFrom = tokenizer.nextToken().equals("from");
                }
                while (inFrom && tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    inFrom = !MessageProcessor.getRFC2822RECEIVEDHeaderFields().contains(token);
                    if (!inFrom) continue;
                    domainBuffer.append(token);
                    domainBuffer.append(' ');
                }
                --headerIndex;
            }
        }
        if (domainBuffer.length() == 0) {
            try {
                domainBuffer.append(this.getDNSServer().getLocalHost().getCanonicalHostName());
            }
            catch (UnknownHostException ue) {
                domainBuffer.append("[127.0.0.1]");
            }
        }
        return domainBuffer.toString().trim();
    }

    protected void handleBouncing(Mail mail) throws MessagingException {
        mail.setState("error");
        this.setMessageDeleted();
        mail.setErrorMessage("This mail from FetchMail task " + this.getFetchTaskName() + " seems to be bouncing!");
        this.logStatusError("Message is bouncing! Deleted from message store and moved to the Error repository.");
    }

    protected void handleParseException(ParseException ex) throws MessagingException {
        if (!this.isLeaveUndeliverable()) {
            this.setMessageDeleted();
        }
        if (this.isMarkUndeliverableSeen()) {
            this.setMessageSeen();
        }
        this.logStatusWarn("Message could not be delivered due to an error parsing a mail address.");
        LOGGER.debug("UNDELIVERABLE Message ID: {}", (Object)this.getMessageIn().getMessageID(), (Object)ex);
    }

    protected void handleUnknownHostException(UnknownHostException ex) throws MessagingException {
        if (!this.isLeaveUndeliverable()) {
            this.setMessageDeleted();
        }
        if (this.isMarkUndeliverableSeen()) {
            this.setMessageSeen();
        }
        this.logStatusWarn("Message could not be delivered due to an error determining the remote domain.");
        LOGGER.debug("UNDELIVERABLE Message ID: {}", (Object)this.getMessageIn().getMessageID(), (Object)ex);
    }

    protected boolean isLocalRecipient(MailAddress recipient) throws UsersRepositoryException {
        return this.isLocalServer(recipient) && this.getLocalUsers().contains(this.getLocalUsers().getUsername(recipient));
    }

    protected boolean isLocalServer(MailAddress recipient) {
        try {
            return this.getConfiguration().getDomainList().containsDomain(recipient.getDomain());
        }
        catch (DomainListException e) {
            LOGGER.error("Unable to access DomainList", (Throwable)e);
            return false;
        }
    }

    protected boolean isBlacklistedRecipient(MailAddress recipient) {
        return this.getBlacklist().contains(recipient);
    }

    protected boolean isBouncing() throws MessagingException {
        Enumeration enumeration = this.getMessageIn().getMatchingHeaderLines(new String[]{"X-fetched-from"});
        int count = 0;
        while (enumeration.hasMoreElements()) {
            String header = (String)enumeration.nextElement();
            if (!header.equals(this.getFetchTaskName())) continue;
            ++count;
        }
        return count >= 3;
    }

    protected void sendMail(Mail mail) throws MessagingException {
        this.getMailQueue().enQueue(mail);
        if (!this.isLeave()) {
            this.setMessageDeleted();
        }
        if (this.isMarkSeen()) {
            this.setMessageSeen();
        }
        StringBuilder messageBuffer = new StringBuilder("Spooled message to recipients: ");
        for (MailAddress address : mail.getRecipients()) {
            messageBuffer.append(address);
            messageBuffer.append(' ');
        }
        messageBuffer.append('.');
        this.logStatusInfo(messageBuffer.toString());
    }

    /*
     * Unable to fully structure code
     */
    protected String getEnvelopeRecipient(MimeMessage msg) throws MessagingException {
        block15: {
            block14: {
                res = this.getCustomRecipientHeader();
                if (res == null || res.length() <= 0) break block14;
                headers = msg.getHeader(this.getCustomRecipientHeader());
                if (headers != null) {
                    mailFor = headers[0];
                    if (mailFor.startsWith("<") && mailFor.endsWith(">")) {
                        mailFor = mailFor.substring(1, mailFor.length() - 1);
                    }
                    return mailFor;
                }
                break block15;
            }
            try {
                enumeration = msg.getMatchingHeaderLines(new String[]{"Received"});
                while (enumeration.hasMoreElements()) {
                    received = (String)enumeration.nextElement();
                    nextSearchAt = 0;
                    i = 0;
                    start = 0;
                    end = 0;
                    usableAddress = false;
                    block9: while (!usableAddress && i != -1) {
                        i = received.indexOf("for ", nextSearchAt);
                        if (i <= 0) continue;
                        start = i + 4;
                        end = 0;
                        nextSearchAt = start;
                        block10: for (c = start; c < received.length(); ++c) {
                            ch = received.charAt(c);
                            switch (ch) {
                                case '<': {
                                    continue block10;
                                }
                                case '@': {
                                    usableAddress = true;
                                    continue block10;
                                }
                                case ' ': {
                                    end = c;
                                    ** GOTO lbl39
                                }
                                case ';': {
                                    end = c;
                                }
lbl39:
                                // 3 sources

                                default: {
                                    if (end > 0) continue block9;
                                }
                            }
                        }
                    }
                    if (!usableAddress) continue;
                    mailFor = received.substring(start, end);
                    if (mailFor.startsWith("<") && mailFor.endsWith(">")) {
                        mailFor = mailFor.substring(1, mailFor.length() - 1);
                    }
                    return mailFor;
                }
            }
            catch (MessagingException me) {
                this.logStatusWarn("No Received headers found.");
            }
        }
        return null;
    }

    protected MailAddress getIntendedRecipient() throws MessagingException {
        if (this.isIgnoreRecipientHeader()) {
            StringBuilder messageBuffer = new StringBuilder("Ignoring recipient header. Using configured recipient as new envelope recipient: ");
            messageBuffer.append(this.getRecipient());
            messageBuffer.append('.');
            this.logStatusInfo(messageBuffer.toString());
            return this.getRecipient();
        }
        String targetRecipient = this.getEnvelopeRecipient(this.getMessageIn());
        if (targetRecipient != null) {
            MailAddress recipient = new MailAddress(targetRecipient);
            StringBuilder messageBuffer = new StringBuilder("Using original envelope recipient as new envelope recipient: ");
            messageBuffer.append(recipient);
            messageBuffer.append('.');
            this.logStatusInfo(messageBuffer.toString());
            return recipient;
        }
        Address[] allRecipients = this.getMessageIn().getAllRecipients();
        if (allRecipients.length == 1) {
            MailAddress recipient = new MailAddress((InternetAddress)allRecipients[0]);
            StringBuilder messageBuffer = new StringBuilder("Using sole recipient header address as new envelope recipient: ");
            messageBuffer.append(recipient);
            messageBuffer.append('.');
            this.logStatusInfo(messageBuffer.toString());
            return recipient;
        }
        return null;
    }

    protected MimeMessage getMessageIn() {
        return this.fieldMessageIn;
    }

    protected void setMessageIn(MimeMessage messageIn) {
        this.fieldMessageIn = messageIn;
    }

    protected boolean isRemoteRecipient() {
        return this.fieldRemoteRecipient;
    }

    protected boolean isPreviouslyUnprocessed() {
        return true;
    }

    protected void logStatusInfo(String detailMsg) throws MessagingException {
        LOGGER.info("{}", (Object)this.getStatusReport(detailMsg));
    }

    protected void logStatusWarn(String detailMsg) throws MessagingException {
        LOGGER.warn("{}", (Object)this.getStatusReport(detailMsg));
    }

    protected void logStatusError(String detailMsg) throws MessagingException {
        LOGGER.error("{}", (Object)this.getStatusReport(detailMsg));
    }

    protected StringBuilder getStatusReport(String detailMsg) throws MessagingException {
        StringBuilder messageBuffer = new StringBuilder(detailMsg);
        if (detailMsg.length() > 0) {
            messageBuffer.append(' ');
        }
        messageBuffer.append("Message ID: ");
        messageBuffer.append(this.getMessageIn().getMessageID());
        messageBuffer.append(". Flags: Seen = ");
        messageBuffer.append((Object)this.isMessageSeen());
        messageBuffer.append(", Delete = ");
        messageBuffer.append((Object)this.isMessageDeleted());
        messageBuffer.append('.');
        return messageBuffer;
    }

    protected boolean isUserUndefined() {
        return this.fieldUserUndefined;
    }

    protected boolean isMessageDeleted() throws MessagingException {
        return this.getMessageIn().isSet(Flags.Flag.DELETED);
    }

    protected boolean isMessageSeen() throws MessagingException {
        return this.getMessageIn().isSet(Flags.Flag.SEEN);
    }

    protected void setMessageDeleted() throws MessagingException {
        this.getMessageIn().setFlag(Flags.Flag.DELETED, true);
    }

    protected void setMessageSeen() throws MessagingException {
        if (!this.getMessageIn().getFolder().getPermanentFlags().contains(Flags.Flag.SEEN)) {
            this.handleMarkSeenNotPermanent();
        } else {
            this.getMessageIn().setFlag(Flags.Flag.SEEN, true);
        }
    }

    protected void handleMarkSeenNotPermanent() throws MessagingException {
        this.getMessageIn().setFlag(Flags.Flag.SEEN, true);
        this.logStatusWarn("Message marked as SEEN, but the folder does not support a permanent SEEN flag.");
    }

    protected boolean isBlacklistedRecipient() {
        return this.fieldBlacklistedRecipient;
    }

    protected void setRemoteRecipient(boolean localRecipient) {
        this.fieldRemoteRecipient = localRecipient;
    }

    protected void setUserUndefined(boolean userUndefined) {
        this.fieldUserUndefined = userUndefined;
    }

    protected void addMailAttributes(Mail aMail) throws MessagingException {
        aMail.setAttribute(new Attribute(this.makeAttributeName("taskName"), AttributeValue.of((String)this.getFetchTaskName())));
        aMail.setAttribute(new Attribute(this.makeAttributeName("folderName"), AttributeValue.of((String)this.getMessageIn().getFolder().getFullName())));
        if (this.isRemoteRecipient()) {
            aMail.setAttribute(new Attribute(this.makeAttributeName("isRemoteRecipient"), AttributeValue.of((Boolean)true)));
        }
        if (this.isUserUndefined()) {
            aMail.setAttribute(new Attribute(this.makeAttributeName("isUserUndefined"), AttributeValue.of((Boolean)true)));
        }
        if (this.isBlacklistedRecipient()) {
            aMail.setAttribute(new Attribute(this.makeAttributeName("isBlacklistedRecipient"), AttributeValue.of((Boolean)true)));
        }
        if (this.isRecipientNotFound()) {
            aMail.setAttribute(new Attribute(this.makeAttributeName("isRecipientNotFound"), AttributeValue.of((Boolean)true)));
        }
        if (this.isMaxMessageSizeExceeded().booleanValue()) {
            aMail.setAttribute(new Attribute(this.makeAttributeName("isMaxMessageSizeExceeded"), AttributeValue.of((String)Integer.toString(this.getMessageIn().getSize()))));
        }
        if (this.isRemoteReceivedHeaderInvalid().booleanValue()) {
            aMail.setAttribute(new Attribute(this.makeAttributeName("isRemoteReceivedHeaderInvalid"), AttributeValue.of((Boolean)true)));
        }
        if (this.isDefaultSenderLocalPart()) {
            aMail.setAttribute(new Attribute(this.makeAttributeName("isDefaultSenderLocalPart"), AttributeValue.of((Boolean)true)));
        }
        if (this.isDefaultSenderDomainPart()) {
            aMail.setAttribute(new Attribute(this.makeAttributeName("isDefaultSenderDomainPart"), AttributeValue.of((Boolean)true)));
        }
        if (this.isDefaultRemoteAddress()) {
            aMail.setAttribute(new Attribute(this.makeAttributeName("isDefaultRemoteAddress"), AttributeValue.of((Boolean)true)));
        }
    }

    protected void addErrorMessages(Mail mail) throws MessagingException {
        if (this.isMaxMessageSizeExceeded().booleanValue()) {
            StringBuilder msgBuffer = new StringBuilder("550 - Rejected - This message has been rejected as the message size of ");
            msgBuffer.append((float)(this.getMessageIn().getSize() * 1000 / 1024) / 1000.0f);
            msgBuffer.append("KB exceeds the maximum permitted size of ");
            msgBuffer.append(this.getMaxMessageSizeLimit() / 1024);
            msgBuffer.append("KB.");
            mail.setErrorMessage(msgBuffer.toString());
        }
    }

    protected void setBlacklistedRecipient(boolean blacklisted) {
        this.fieldBlacklistedRecipient = blacklisted;
    }

    protected boolean isRecipientNotFound() {
        return this.fieldRecipientNotFound;
    }

    protected void setRecipientNotFound(boolean recipientNotFound) {
        this.fieldRecipientNotFound = recipientNotFound;
    }

    protected String getRemoteDomain() throws MessagingException {
        String remoteDomain = this.getRemoteDomainBasic();
        if (null == remoteDomain) {
            this.updateRemoteDomain();
            return this.getRemoteDomain();
        }
        return remoteDomain;
    }

    private String getRemoteDomainBasic() {
        return this.fieldRemoteDomain;
    }

    protected void setRemoteDomain(String remoteDomain) {
        this.fieldRemoteDomain = remoteDomain;
    }

    protected void updateRemoteDomain() throws MessagingException {
        this.setRemoteDomain(this.computeRemoteDomain());
    }

    protected String computeRemoteAddress() throws MessagingException, UnknownHostException {
        String address;
        String domain = this.getRemoteDomain();
        int ipAddressStart = domain.indexOf(91);
        int ipAddressEnd = -1;
        if (ipAddressStart > -1) {
            ipAddressEnd = domain.indexOf(93, ipAddressStart);
        } else {
            ipAddressStart = domain.indexOf(40);
            if (ipAddressStart > -1) {
                ipAddressEnd = domain.indexOf(41, ipAddressStart);
            }
        }
        if (ipAddressEnd > -1) {
            address = domain.substring(ipAddressStart + 1, ipAddressEnd);
        } else {
            int hostNameEnd = domain.indexOf(32);
            if (hostNameEnd == -1) {
                hostNameEnd = domain.length();
            }
            address = domain.substring(0, hostNameEnd);
        }
        String validatedAddress = this.getDNSServer().getByName(address).getHostAddress();
        return validatedAddress;
    }

    protected String computeRemoteHostName() throws MessagingException, UnknownHostException {
        return this.getDNSServer().getHostName(this.getDNSServer().getByName(this.getRemoteAddress()));
    }

    protected String getRemoteAddress() throws MessagingException, UnknownHostException {
        String remoteAddress = this.getRemoteAddressBasic();
        if (null == remoteAddress) {
            this.updateRemoteAddress();
            return this.getRemoteAddress();
        }
        return remoteAddress;
    }

    private String getRemoteAddressBasic() {
        return this.fieldRemoteAddress;
    }

    protected String getRemoteHostName() throws MessagingException, UnknownHostException {
        String remoteHostName = this.getRemoteHostNameBasic();
        if (null == remoteHostName) {
            this.updateRemoteHostName();
            return this.getRemoteHostName();
        }
        return remoteHostName;
    }

    private String getRemoteHostNameBasic() {
        return this.fieldRemoteHostName;
    }

    protected void setRemoteAddress(String remoteAddress) {
        this.fieldRemoteAddress = remoteAddress;
    }

    protected void updateRemoteAddress() throws MessagingException, UnknownHostException {
        this.setRemoteAddress(this.computeRemoteAddress());
    }

    protected void setRemoteHostName(String remoteHostName) {
        this.fieldRemoteHostName = remoteHostName;
    }

    protected void updateRemoteHostName() throws MessagingException, UnknownHostException {
        this.setRemoteHostName(this.computeRemoteHostName());
    }

    public static String getRFC2822RECEIVEDHeaderFields() {
        return fieldRFC2822RECEIVEDHeaderFields;
    }

    protected Boolean isMaxMessageSizeExceeded() throws MessagingException {
        Boolean isMaxMessageSizeExceeded = this.isMaxMessageSizeExceededBasic();
        if (null == isMaxMessageSizeExceeded) {
            this.updateMaxMessageSizeExceeded();
            return this.isMaxMessageSizeExceeded();
        }
        return isMaxMessageSizeExceeded;
    }

    protected void updateMaxMessageSizeExceeded() throws MessagingException {
        this.setMaxMessageSizeExceeded(this.computeMaxMessageSizeExceeded());
    }

    protected Boolean computeMaxMessageSizeExceeded() throws MessagingException {
        if (0 == this.getMaxMessageSizeLimit()) {
            return Boolean.FALSE;
        }
        return this.getMessageIn().getSize() > this.getMaxMessageSizeLimit();
    }

    private Boolean isMaxMessageSizeExceededBasic() {
        return this.fieldMaxMessageSizeExceeded;
    }

    protected void setMaxMessageSizeExceeded(Boolean maxMessageSizeExceeded) {
        this.fieldMaxMessageSizeExceeded = maxMessageSizeExceeded;
    }

    protected Boolean isRemoteReceivedHeaderInvalid() throws MessagingException {
        Boolean isInvalid = this.isRemoteReceivedHeaderInvalidBasic();
        if (null == isInvalid) {
            this.updateRemoteReceivedHeaderInvalid();
            return this.isRemoteReceivedHeaderInvalid();
        }
        return isInvalid;
    }

    protected Boolean computeRemoteReceivedHeaderInvalid() throws MessagingException {
        Boolean isInvalid = Boolean.FALSE;
        try {
            this.getRemoteAddress();
        }
        catch (UnknownHostException e) {
            isInvalid = Boolean.TRUE;
        }
        return isInvalid;
    }

    private Boolean isRemoteReceivedHeaderInvalidBasic() {
        return this.fieldRemoteReceivedHeaderInvalid;
    }

    protected void setRemoteReceivedHeaderInvalid(Boolean remoteReceivedHeaderInvalid) {
        this.fieldRemoteReceivedHeaderInvalid = remoteReceivedHeaderInvalid;
    }

    protected void updateRemoteReceivedHeaderInvalid() throws MessagingException {
        this.setRemoteReceivedHeaderInvalid(this.computeRemoteReceivedHeaderInvalid());
    }

    protected boolean isDefaultSenderDomainPart() {
        return this.fieldDefaultSenderDomainPart;
    }

    protected boolean isDefaultSenderLocalPart() {
        return this.fieldDefaultSenderLocalPart;
    }

    protected void setDefaultSenderDomainPart(boolean defaultSenderDomainPart) {
        this.fieldDefaultSenderDomainPart = defaultSenderDomainPart;
    }

    protected void setDefaultSenderLocalPart(boolean defaultSenderLocalPart) {
        this.fieldDefaultSenderLocalPart = defaultSenderLocalPart;
    }

    protected boolean isDefaultRemoteAddress() {
        return this.fieldDefaultRemoteAddress;
    }

    protected void setDefaultRemoteAddress(boolean defaultRemoteAddress) {
        this.fieldDefaultRemoteAddress = defaultRemoteAddress;
    }

    private AttributeName makeAttributeName(String suffix) {
        return AttributeName.of((String)(this.getAttributePrefix() + suffix));
    }
}

