/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.AbstractPOP3CommandHandler;
import org.apache.james.protocols.pop3.core.CapaCapability;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.util.MDCBuilder;

public class CapaCmdHandler
extends AbstractPOP3CommandHandler
implements ExtensibleHandler,
CapaCapability {
    private List<CapaCapability> caps;
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"CAPA");
    private static final Set<String> CAPS = ImmutableSet.of((Object)"PIPELINING");
    private final MetricFactory metricFactory;

    @Inject
    public CapaCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    @Override
    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-capa", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addToContext("action", "CAPA").addToContext(MDCConstants.withSession(session)), () -> this.capa(session)));
    }

    private Response capa(POP3Session session) {
        POP3Response response = new POP3Response("+OK", "Capability list follows");
        for (CapaCapability capabilities : this.caps) {
            for (String cap : capabilities.getImplementedCapabilities(session)) {
                response.appendLine(cap);
            }
        }
        response.appendLine(".");
        return response;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList mList = new ArrayList();
        mList.add(CapaCapability.class);
        return mList;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (interfaceName.equals(CapaCapability.class)) {
            this.caps = extension;
        }
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    public Set<String> getImplementedCapabilities(POP3Session session) {
        return CAPS;
    }
}

