/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Collection;
import org.apache.james.ExtraProperties;
import org.apache.james.GuiceJamesServer;
import org.apache.james.JPAJamesConfiguration;
import org.apache.james.JamesServerMain;
import org.apache.james.NaiveDelegationStoreModule;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.store.extractor.JsoupTextExtractor;
import org.apache.james.modules.MailboxModule;
import org.apache.james.modules.MailetProcessingModule;
import org.apache.james.modules.RunArgumentsModule;
import org.apache.james.modules.data.JPADataModule;
import org.apache.james.modules.data.JPADropListsModule;
import org.apache.james.modules.data.JPAUsersRepositoryModule;
import org.apache.james.modules.data.SieveJPARepositoryModules;
import org.apache.james.modules.mailbox.DefaultEventModule;
import org.apache.james.modules.mailbox.JPAMailboxModule;
import org.apache.james.modules.mailbox.LuceneSearchMailboxModule;
import org.apache.james.modules.mailbox.MemoryDeadLetterModule;
import org.apache.james.modules.mailbox.ReIndexingTaskSerializationModule;
import org.apache.james.modules.protocols.IMAPServerModule;
import org.apache.james.modules.protocols.LMTPServerModule;
import org.apache.james.modules.protocols.ManageSieveServerModule;
import org.apache.james.modules.protocols.POP3ServerModule;
import org.apache.james.modules.protocols.ProtocolHandlerModule;
import org.apache.james.modules.protocols.SMTPServerModule;
import org.apache.james.modules.queue.activemq.ActiveMQQueueModule;
import org.apache.james.modules.server.DataRoutesModules;
import org.apache.james.modules.server.DefaultProcessorsConfigurationProviderModule;
import org.apache.james.modules.server.DropListsRoutesModule;
import org.apache.james.modules.server.InconsistencyQuotasSolvingRoutesModule;
import org.apache.james.modules.server.JMXServerModule;
import org.apache.james.modules.server.MailQueueRoutesModule;
import org.apache.james.modules.server.MailRepositoriesRoutesModule;
import org.apache.james.modules.server.MailboxRoutesModule;
import org.apache.james.modules.server.NoJwtModule;
import org.apache.james.modules.server.RawPostDequeueDecoratorModule;
import org.apache.james.modules.server.ReIndexingModule;
import org.apache.james.modules.server.SieveRoutesModule;
import org.apache.james.modules.server.TaskManagerModule;
import org.apache.james.modules.server.WebAdminMailOverWebModule;
import org.apache.james.modules.server.WebAdminReIndexingTaskSerializationModule;
import org.apache.james.modules.server.WebAdminServerModule;
import org.apache.james.server.core.configuration.Configuration;

public class JPAJamesServerMain
implements JamesServerMain {
    private static final Module WEBADMIN = Modules.combine((Module[])new Module[]{new WebAdminServerModule(), new DataRoutesModules(), new InconsistencyQuotasSolvingRoutesModule(), new MailboxRoutesModule(), new MailQueueRoutesModule(), new MailRepositoriesRoutesModule(), new ReIndexingModule(), new SieveRoutesModule(), new WebAdminReIndexingTaskSerializationModule(), new WebAdminMailOverWebModule()});
    private static final Module PROTOCOLS = Modules.combine((Module[])new Module[]{new IMAPServerModule(), new LMTPServerModule(), new ManageSieveServerModule(), new POP3ServerModule(), new ProtocolHandlerModule(), new SMTPServerModule(), WEBADMIN});
    private static final Module SEARCH_MODULE = Modules.combine((Module[])new Module[]{new LuceneSearchMailboxModule(), binder -> binder.bind(TextExtractor.class).toInstance((Object)new JsoupTextExtractor())});
    private static final Module JPA_SERVER_MODULE = Modules.combine((Module[])new Module[]{SEARCH_MODULE, new ActiveMQQueueModule(), new NaiveDelegationStoreModule(), new DefaultProcessorsConfigurationProviderModule(), new JPADataModule(), new JPAMailboxModule(), new MailboxModule(), new ReIndexingTaskSerializationModule(), new NoJwtModule(), new RawPostDequeueDecoratorModule(), new SieveJPARepositoryModules(), new DefaultEventModule(), new TaskManagerModule(), new MemoryDeadLetterModule()});
    private static final Module JPA_MODULE_AGGREGATE = Modules.combine((Module[])new Module[]{new MailetProcessingModule(), JPA_SERVER_MODULE, PROTOCOLS});

    public static void main(String[] args) throws Exception {
        ExtraProperties.initialize();
        JPAJamesConfiguration configuration = JPAJamesConfiguration.builder().useWorkingDirectoryEnvProperty().build();
        LOGGER.info("Loading configuration {}", (Object)configuration.toString());
        GuiceJamesServer server = JPAJamesServerMain.createServer(configuration).combineWith(new Module[]{new JMXServerModule()}).overrideWith(new Module[]{new RunArgumentsModule(args)}).overrideWith(new Module[]{JPAJamesServerMain.chooseDropListsModule(configuration)});
        JamesServerMain.main((GuiceJamesServer)server);
    }

    static GuiceJamesServer createServer(JPAJamesConfiguration configuration) {
        return GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{JPA_MODULE_AGGREGATE}).combineWith((Collection)new UsersRepositoryModuleChooser((Module)new JPAUsersRepositoryModule()).chooseModules(configuration.getUsersRepositoryImplementation()));
    }

    private static Module chooseDropListsModule(JPAJamesConfiguration configuration) {
        if (configuration.isDropListsEnabled()) {
            return Modules.combine((Module[])new Module[]{new JPADropListsModule(), new DropListsRoutesModule()});
        }
        return binder -> {};
    }
}

