/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.collect.ImmutableList;
import jakarta.mail.MessagingException;
import java.util.Collection;
import java.util.Optional;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.ProcessingState;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToProcessor
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToProcessor.class);
    private boolean debug;
    private ProcessingState processor;
    private Optional<String> noticeText;

    public void init() throws MailetException {
        this.debug = this.isDebug();
        this.processor = new ProcessingState(Optional.ofNullable(this.getInitParameter("processor")).orElseThrow(() -> new MailetException("processor parameter is required")));
        this.noticeText = Optional.ofNullable(this.getInitParameter("notice"));
    }

    private boolean isDebug() {
        return this.getInitParameter("debug", false);
    }

    public String getMailetInfo() {
        return "ToProcessor Mailet";
    }

    public void service(Mail mail) throws MessagingException {
        if (this.debug) {
            LOGGER.debug("Sending mail {} to {}", (Object)mail, (Object)this.processor);
        }
        mail.setState(this.processor.getValue());
        if (this.noticeText.isPresent()) {
            this.setNoticeInErrorMessage(mail);
        }
    }

    private void setNoticeInErrorMessage(Mail mail) {
        if (mail.getErrorMessage() == null) {
            mail.setErrorMessage(this.noticeText.get());
        } else {
            mail.setErrorMessage(String.format("%s\r\n%s", mail.getErrorMessage(), this.noticeText.get()));
        }
    }

    public Collection<ProcessingState> requiredProcessingState() {
        return ImmutableList.of((Object)this.processor);
    }
}

