/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.core.ScrollResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ScrollRequest
extends RequestBase
implements PlainJsonSerializable {
    @Nullable
    private final Time scroll;
    private final String scrollId;
    public static final JsonpDeserializer<ScrollRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScrollRequest::setupScrollRequestDeserializer);
    public static final SimpleEndpoint<ScrollRequest, ?> _ENDPOINT = new SimpleEndpoint<ScrollRequest, ScrollResponse<Object>>(request -> "POST", request -> "/_search/scroll", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ScrollResponse._DESERIALIZER);

    private ScrollRequest(Builder builder) {
        this.scroll = builder.scroll;
        this.scrollId = ApiTypeHelper.requireNonNull(builder.scrollId, this, "scrollId");
    }

    public static ScrollRequest of(Function<Builder, ObjectBuilder<ScrollRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time scroll() {
        return this.scroll;
    }

    public final String scrollId() {
        return this.scrollId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.scroll != null) {
            generator.writeKey("scroll");
            this.scroll.serialize(generator, mapper);
        }
        generator.writeKey("scroll_id");
        generator.write(this.scrollId);
    }

    public Builder toBuilder() {
        return new Builder().scroll(this.scroll).scrollId(this.scrollId);
    }

    protected static void setupScrollRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::scroll, Time._DESERIALIZER, "scroll");
        op.add(Builder::scrollId, JsonpDeserializer.stringDeserializer(), "scroll_id");
    }

    public static <TDocument> Endpoint<ScrollRequest, ScrollResponse<TDocument>, ErrorResponse> createScrollEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(ScrollResponse.createScrollResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ScrollRequest> {
        @Nullable
        private Time scroll;
        private String scrollId;

        public final Builder scroll(@Nullable Time value) {
            this.scroll = value;
            return this;
        }

        public final Builder scroll(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.scroll(fn.apply(new Time.Builder()).build());
        }

        public final Builder scrollId(String value) {
            this.scrollId = value;
            return this;
        }

        @Override
        public ScrollRequest build() {
            this._checkSingleUse();
            return new ScrollRequest(this);
        }
    }
}

