/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore.validation;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.modules.blobstore.validation.RegisterStorageStrategy;
import org.apache.james.modules.blobstore.validation.RegisterStorageStrategyCommandHandler;
import org.apache.james.server.blob.deduplication.StorageStrategy;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class StorageStrategyValidationEventSourcingSystem {
    public static final String CHECK = "blobstore-storage-strategy-configuration-check";
    private final EventSourcingSystem eventSourcingSystem;

    @Inject
    public StorageStrategyValidationEventSourcingSystem(EventStore eventStore) {
        this.eventSourcingSystem = EventSourcingSystem.fromJava((Set)ImmutableSet.of((Object)new RegisterStorageStrategyCommandHandler(eventStore)), (Set)ImmutableSet.of(), (EventStore)eventStore);
    }

    public StartUpCheck.CheckResult validate(Supplier<StorageStrategy> storageStrategySupplier) {
        return (StartUpCheck.CheckResult)Mono.from((Publisher)this.eventSourcingSystem.dispatch((Command)new RegisterStorageStrategy(storageStrategySupplier.get()))).thenReturn((Object)StartUpCheck.CheckResult.builder().checkName(CHECK).resultType(StartUpCheck.ResultType.GOOD).build()).onErrorResume(IllegalStateException.class, e -> Mono.just((Object)StartUpCheck.CheckResult.builder().checkName(CHECK).resultType(StartUpCheck.ResultType.BAD).description(e.getMessage()).build())).block();
    }
}

