/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import jakarta.mail.Flags;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;

public class MessageMetaData {
    private final MessageUid uid;
    private final Flags flags;
    private final long size;
    private final Date internalDate;
    private final Optional<Date> saveDate;
    private final ModSeq modSeq;
    private final MessageId messageId;
    private final ThreadId threadId;

    public MessageMetaData(MessageUid uid, ModSeq modSeq, Flags flags, long size, Date internalDate, Optional<Date> saveDate, MessageId messageId, ThreadId threadId) {
        this.uid = uid;
        this.flags = flags;
        this.size = size;
        this.modSeq = modSeq;
        this.internalDate = internalDate;
        this.saveDate = saveDate;
        this.messageId = messageId;
        this.threadId = threadId;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public long getSize() {
        return this.size;
    }

    public Date getInternalDate() {
        return this.internalDate;
    }

    public Optional<Date> getSaveDate() {
        return this.saveDate;
    }

    public MessageUid getUid() {
        return this.uid;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public ThreadId getThreadId() {
        return this.threadId;
    }

    public ModSeq getModSeq() {
        return this.modSeq;
    }

    public final boolean equals(Object o) {
        if (o instanceof MessageMetaData) {
            MessageMetaData that = (MessageMetaData)o;
            return Objects.equals(this.uid, that.uid) && Objects.equals(this.size, that.size) && Objects.equals(this.flags, that.flags) && Objects.equals(this.internalDate, that.internalDate) && Objects.equals(this.saveDate, that.saveDate) && Objects.equals(this.modSeq, that.modSeq) && Objects.equals(this.messageId, that.messageId) && Objects.equals(this.threadId, that.threadId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.uid, this.flags, this.size, this.internalDate, this.saveDate, this.modSeq, this.messageId, this.threadId);
    }
}

