/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.rewrite;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzerFactory;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Parameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public final class StatementRewrite {
    private final Set<Rewrite> rewrites;
    public static final StatementRewrite NOOP = new StatementRewrite((Set<Rewrite>)ImmutableSet.of());

    public StatementRewrite(Set<Rewrite> rewrites) {
        this.rewrites = ImmutableSet.copyOf((Collection)Objects.requireNonNull(rewrites, "rewrites is null"));
    }

    public Statement rewrite(StatementAnalyzerFactory analyzerFactory, SessionInfo session, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector) {
        for (Rewrite rewrite : this.rewrites) {
            node = Objects.requireNonNull(rewrite.rewrite(analyzerFactory, session, node, parameters, parameterLookup, warningCollector), "Statement rewrite returned null");
        }
        return node;
    }

    public static interface Rewrite {
        public Statement rewrite(StatementAnalyzerFactory var1, SessionInfo var2, Statement var3, List<Expression> var4, Map<NodeRef<Parameter>, Expression> var5, WarningCollector var6);
    }
}

