/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class OffsetNode
extends SingleChildProcessNode {
    private final long count;

    public OffsetNode(PlanNodeId id, PlanNode child, long count) {
        super(id, child);
        this.count = count;
    }

    @Override
    public PlanNode clone() {
        return new OffsetNode(this.id, null, this.count);
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitOffset(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_OFFSET_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((long)this.count, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_OFFSET_NODE.serialize(stream);
        ReadWriteIOUtils.write((long)this.count, (OutputStream)stream);
    }

    public static OffsetNode deserialize(ByteBuffer byteBuffer) {
        long count = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new OffsetNode(planNodeId, null, count);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.child.getOutputSymbols();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new OffsetNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.count);
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetNode offsetNode = (OffsetNode)o;
        return Objects.equal((Object)this.count, (Object)offsetNode.count);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.count});
    }

    public String toString() {
        return "OffsetNode-" + this.getPlanNodeId();
    }
}

