/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path;

import java.util.Objects;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class NonAlignedFullPath
implements IFullPath {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(NonAlignedFullPath.class);
    private final IDeviceID deviceID;
    private final IMeasurementSchema measurementSchema;

    public NonAlignedFullPath(IDeviceID deviceID, IMeasurementSchema measurementSchema) {
        this.deviceID = deviceID;
        this.measurementSchema = measurementSchema;
    }

    @Override
    public IDeviceID getDeviceId() {
        return this.deviceID;
    }

    @Override
    public TSDataType getSeriesType() {
        return this.measurementSchema.getType();
    }

    public IMeasurementSchema getMeasurementSchema() {
        return this.measurementSchema;
    }

    public String getMeasurement() {
        return this.measurementSchema.getMeasurementName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonAlignedFullPath that = (NonAlignedFullPath)o;
        return Objects.equals(this.deviceID, that.deviceID) && Objects.equals(this.measurementSchema, that.measurementSchema);
    }

    public int hashCode() {
        return Objects.hash(this.deviceID, this.measurementSchema);
    }

    public String toString() {
        return "NonAlignedFullPath{deviceID=" + this.deviceID + ", measurementSchema=" + this.measurementSchema + '}';
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.deviceID.ramBytesUsed() + RamUsageEstimator.sizeOf((String)this.measurementSchema.getMeasurementName());
    }
}

