/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.binaryschema.generator;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.namespace.QName;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.enumerated.StructureType;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumField;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureField;
import org.opcfoundation.opcua.binaryschema.ByteOrder;
import org.opcfoundation.opcua.binaryschema.EnumeratedType;
import org.opcfoundation.opcua.binaryschema.EnumeratedValue;
import org.opcfoundation.opcua.binaryschema.FieldType;
import org.opcfoundation.opcua.binaryschema.ImportDirective;
import org.opcfoundation.opcua.binaryschema.ObjectFactory;
import org.opcfoundation.opcua.binaryschema.StructuredType;
import org.opcfoundation.opcua.binaryschema.TypeDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeDictionaryGenerator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<String> namespaces = new HashSet<String>();
    private final List<EnumeratedType> enumeratedTypes = new ArrayList<EnumeratedType>();
    private final List<StructuredType> structuredTypes = new ArrayList<StructuredType>();
    private final Map<NodeId, StructureDescription> structureDescriptions = new HashMap<NodeId, StructureDescription>();
    private final String namespaceUri;
    private final Function<NodeId, DataTypeLocation> dataTypeLookup;

    public DataTypeDictionaryGenerator(String namespaceUri, Function<NodeId, DataTypeLocation> dataTypeLookup) {
        this.namespaceUri = namespaceUri;
        this.dataTypeLookup = dataTypeLookup;
    }

    public void addEnumDescription(EnumDescription description) {
        UByte builtInType = description.getBuiltInType();
        if (builtInType.intValue() != BuiltinDataType.Int32.getTypeId()) {
            throw new IllegalArgumentException("BuiltInType must be Int32");
        }
        this.enumeratedTypes.add(this.createEnumeratedType(description));
    }

    public void addStructureDescription(StructureDescription description) {
        this.structuredTypes.add(this.createStructuredType(description));
        this.structureDescriptions.put(description.getDataTypeId(), description);
    }

    public void writeToOutputStream(OutputStream outputStream) throws IOException {
        TypeDictionary typeDictionary = new TypeDictionary();
        typeDictionary.setDefaultByteOrder(ByteOrder.LITTLE_ENDIAN);
        typeDictionary.setTargetNamespace(this.namespaceUri);
        this.enumeratedTypes.forEach(t -> typeDictionary.getOpaqueTypeOrEnumeratedTypeOrStructuredType().add(t));
        this.structuredTypes.forEach(t -> typeDictionary.getOpaqueTypeOrEnumeratedTypeOrStructuredType().add(t));
        this.namespaces.forEach(namespace -> {
            ImportDirective importDirective = new ImportDirective();
            importDirective.setNamespace(namespace);
            typeDictionary.getImport().add(importDirective);
        });
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            try {
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new OpcUaNamespacePrefixMapper());
            }
            catch (PropertyException e) {
                this.logger.debug("NamespacePrefixMapper not supported", (Throwable)e);
            }
            marshaller.marshal((Object)typeDictionary, outputStream);
        }
        catch (Throwable t2) {
            throw new IOException("failed to write dictionary to OutputStream", t2);
        }
    }

    private EnumeratedType createEnumeratedType(EnumDescription description) {
        QualifiedName name = description.getName();
        EnumDefinition definition = description.getEnumDefinition();
        EnumeratedType enumeratedType = new EnumeratedType();
        enumeratedType.setName(name.getName());
        enumeratedType.setLengthInBits(Integer.valueOf(32));
        for (EnumField field : definition.getFields()) {
            EnumeratedValue enumeratedValue = new EnumeratedValue();
            enumeratedValue.setName(field.getName());
            enumeratedValue.setValue(Integer.valueOf(field.getValue().intValue()));
            enumeratedType.getEnumeratedValue().add(enumeratedValue);
        }
        return enumeratedType;
    }

    private StructuredType createStructuredType(StructureDescription description) {
        QualifiedName name = description.getName();
        StructureDefinition definition = description.getStructureDefinition();
        StructureType structureType = definition.getStructureType();
        StructuredType structuredType = new StructuredType();
        structuredType.setName(name.getName());
        LinkedList<StructureDefinition> definitions = new LinkedList<StructureDefinition>();
        definitions.addFirst(definition);
        NodeId baseDataTypeId = definition.getBaseDataType();
        while (baseDataTypeId != null && baseDataTypeId.isNotNull() && !Identifiers.Structure.equals((Object)baseDataTypeId) && !Identifiers.Union.equals((Object)baseDataTypeId)) {
            StructureDescription baseDescription = this.structureDescriptions.get(baseDataTypeId);
            StructureDefinition baseDefinition = baseDescription.getStructureDefinition();
            definitions.addFirst(baseDefinition);
            baseDataTypeId = baseDefinition.getBaseDataType();
        }
        LinkedHashMap<String, Object> allFields = new LinkedHashMap<String, Object>();
        for (StructureDefinition d : definitions) {
            for (StructureField f : d.getFields()) {
                allFields.put(f.getName(), f);
            }
        }
        ArrayList fields = new ArrayList(allFields.values());
        if (structureType == StructureType.StructureWithOptionalFields) {
            int optionalFieldCount = 0;
            for (StructureField field : fields) {
                if (!field.getIsOptional().booleanValue()) continue;
                ++optionalFieldCount;
                FieldType fieldType = new FieldType();
                fieldType.setName(field.getName() + "Present");
                fieldType.setTypeName(new QName("http://opcfoundation.org/BinarySchema/", "Bit"));
                structuredType.getField().add(fieldType);
            }
            if (optionalFieldCount > 0) {
                int reservedFieldCount = (optionalFieldCount + 31) / 32;
                for (int i = 0; i < reservedFieldCount; ++i) {
                    long reservedBits = 32 - optionalFieldCount;
                    optionalFieldCount -= 32;
                    FieldType fieldType = new FieldType();
                    fieldType.setLength(Long.valueOf(reservedBits));
                    fieldType.setName("Reserved" + i);
                    fieldType.setTypeName(new QName("http://opcfoundation.org/BinarySchema/", "Bit"));
                    structuredType.getField().add(fieldType);
                }
            }
        } else if (structureType == StructureType.Union) {
            FieldType fieldType = new FieldType();
            fieldType.setName("SwitchField");
            fieldType.setTypeName(new QName("http://opcfoundation.org/BinarySchema/", "UInt32"));
            structuredType.getField().add(fieldType);
        }
        long switchValue = 0L;
        for (StructureField field : fields) {
            String fieldName = field.getName();
            NodeId fieldDataTypeId = field.getDataType();
            DataTypeLocation dataTypeLocation = this.dataTypeLookup.apply(fieldDataTypeId);
            String dataTypeName = dataTypeLocation.dataTypeName;
            String dictionaryNamespaceUri = dataTypeLocation.dictionaryNamespaceUri;
            if (!dictionaryNamespaceUri.isEmpty()) {
                this.namespaces.add(dictionaryNamespaceUri);
            }
            FieldType fieldType = new FieldType();
            fieldType.setName(fieldName);
            if (dictionaryNamespaceUri.isEmpty()) {
                fieldType.setTypeName(new QName(this.namespaceUri, dataTypeName));
            } else {
                fieldType.setTypeName(new QName(dictionaryNamespaceUri, dataTypeName));
            }
            if (structureType == StructureType.StructureWithOptionalFields) {
                if (field.getIsOptional().booleanValue()) {
                    fieldType.setSwitchField(fieldName + "Present");
                }
            } else if (structureType == StructureType.Union) {
                fieldType.setSwitchField("SwitchField");
                fieldType.setSwitchValue(Long.valueOf(++switchValue));
            }
            if (field.getValueRank() >= 1) {
                FieldType lengthFieldType = new FieldType();
                lengthFieldType.setName(fieldName + "Length");
                lengthFieldType.setTypeName(new QName("http://opcfoundation.org/BinarySchema/", "Int32"));
                if (structureType == StructureType.StructureWithOptionalFields) {
                    if (field.getIsOptional().booleanValue()) {
                        lengthFieldType.setSwitchField(fieldName + "Present");
                    }
                } else if (structureType == StructureType.Union) {
                    fieldType.setSwitchField("SwitchField");
                    fieldType.setSwitchValue(Long.valueOf(switchValue));
                }
                structuredType.getField().add(lengthFieldType);
                fieldType.setLengthField(fieldName + "Length");
            } else if (field.getValueRank() != -1) {
                throw new IllegalArgumentException("cannot encode field \"" + fieldName + "\" with ValueRank: %s" + field.getValueRank());
            }
            structuredType.getField().add(fieldType);
        }
        return structuredType;
    }

    private static class OpcUaNamespacePrefixMapper
    extends NamespacePrefixMapper {
        private OpcUaNamespacePrefixMapper() {
        }

        public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
            if ("http://opcfoundation.org/BinarySchema/".equals(namespaceUri)) {
                return "opc";
            }
            if ("http://opcfoundation.org/UA/".equals(namespaceUri)) {
                return "ua";
            }
            return null;
        }
    }

    public static class DataTypeLocation {
        final String dataTypeName;
        final String dictionaryNamespaceUri;

        public DataTypeLocation(String dataTypeName, String dictionaryNamespaceUri) {
            this.dataTypeName = dataTypeName;
            this.dictionaryNamespaceUri = dictionaryNamespaceUri;
        }
    }
}

