/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.datastructure.BatchEncodeInfo;
import org.apache.iotdb.db.utils.datastructure.MultiTVListIterator;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;

public class MergeSortMultiTVListIterator
extends MultiTVListIterator {
    private final List<Integer> probeIterators;
    private final PriorityQueue<Pair<Long, Integer>> heap;

    public MergeSortMultiTVListIterator(Ordering scanOrder, Filter globalTimeFilter, TSDataType tsDataType, List<TVList> tvLists, List<Integer> tvListRowCounts, List<TimeRange> deletionList, Integer floatPrecision, TSEncoding encoding, int maxNumberOfPointsInPage) {
        super(scanOrder, globalTimeFilter, tsDataType, tvLists, tvListRowCounts, deletionList, floatPrecision, encoding, maxNumberOfPointsInPage);
        this.probeIterators = IntStream.range(0, this.tvListIterators.size()).boxed().collect(Collectors.toList());
        this.heap = new PriorityQueue(scanOrder.isAscending() ? (a, b) -> ((Long)a.left).equals(b.left) ? ((Integer)b.right).compareTo((Integer)a.right) : ((Long)a.left).compareTo((Long)b.left) : (a, b) -> ((Long)a.left).equals(b.left) ? ((Integer)a.right).compareTo((Integer)b.right) : ((Long)b.left).compareTo((Long)a.left));
    }

    @Override
    protected void skipToCurrentTimeRangeStartPosition() {
        this.hasNext = false;
        this.probeIterators.clear();
        for (int i = 0; i < this.tvListIterators.size(); ++i) {
            TVList.TVListIterator iterator = (TVList.TVListIterator)this.tvListIterators.get(i);
            iterator.skipToCurrentTimeRangeStartPosition();
            if (!iterator.hasNextTimeValuePair()) continue;
            this.probeIterators.add(i);
        }
        this.probeNext = false;
    }

    @Override
    protected void prepareNext() {
        this.hasNext = false;
        for (int i : this.probeIterators) {
            TVList.TVListIterator iterator = (TVList.TVListIterator)this.tvListIterators.get(i);
            if (!iterator.hasNextTimeValuePair()) continue;
            this.heap.add((Pair<Long, Integer>)new Pair((Object)iterator.currentTime(), (Object)i));
        }
        this.probeIterators.clear();
        if (!this.heap.isEmpty()) {
            Pair<Long, Integer> top = this.heap.poll();
            this.currentTime = (Long)top.left;
            this.probeIterators.add((Integer)top.right);
            this.iteratorIndex = (Integer)top.right;
            this.rowIndex = ((TVList.TVListIterator)this.tvListIterators.get(this.iteratorIndex)).getIndex();
            this.hasNext = true;
            while (!this.heap.isEmpty() && (Long)this.heap.peek().left == this.currentTime) {
                Pair<Long, Integer> element = this.heap.poll();
                this.probeIterators.add((Integer)element.right);
            }
        }
        this.probeNext = true;
    }

    @Override
    protected void next() {
        for (int index : this.probeIterators) {
            ((TVList.TVListIterator)this.tvListIterators.get(index)).next();
        }
        this.probeNext = false;
    }

    @Override
    public void encodeBatch(IChunkWriter chunkWriter, BatchEncodeInfo encodeInfo, long[] times) {
        ChunkWriterImpl chunkWriterImpl = (ChunkWriterImpl)chunkWriter;
        while (this.hasNextTimeValuePair()) {
            TVList.TVListIterator currIterator = (TVList.TVListIterator)this.tvListIterators.get(this.iteratorIndex);
            int row = this.rowIndex;
            long time = this.currentTime;
            this.next();
            if (!this.hasNextTimeValuePair()) {
                chunkWriterImpl.setLastPoint(true);
            }
            switch (this.tsDataType) {
                case BOOLEAN: {
                    chunkWriterImpl.write(time, currIterator.getTVList().getBoolean(row));
                    encodeInfo.dataSizeInChunk += 9L;
                    break;
                }
                case INT32: 
                case DATE: {
                    chunkWriterImpl.write(time, currIterator.getTVList().getInt(row));
                    encodeInfo.dataSizeInChunk += 12L;
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    chunkWriterImpl.write(time, currIterator.getTVList().getLong(row));
                    encodeInfo.dataSizeInChunk += 16L;
                    break;
                }
                case FLOAT: {
                    chunkWriterImpl.write(time, currIterator.getTVList().getFloat(row));
                    encodeInfo.dataSizeInChunk += 12L;
                    break;
                }
                case DOUBLE: {
                    chunkWriterImpl.write(time, currIterator.getTVList().getDouble(row));
                    encodeInfo.dataSizeInChunk += 16L;
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    Binary value = currIterator.getTVList().getBinary(row);
                    chunkWriterImpl.write(time, value);
                    encodeInfo.dataSizeInChunk += 8L + MemUtils.getBinarySize(value);
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.tsDataType));
                }
            }
            ++encodeInfo.pointNumInChunk;
            if ((long)encodeInfo.pointNumInChunk < encodeInfo.maxNumberOfPointsInChunk && encodeInfo.dataSizeInChunk < encodeInfo.targetChunkSize) continue;
            break;
        }
    }

    @Override
    public void setCurrentPageTimeRange(TimeRange timeRange) {
        for (TVList.TVListIterator tvListIterator : this.tvListIterators) {
            tvListIterator.timeRange = timeRange;
        }
        super.setCurrentPageTimeRange(timeRange);
    }
}

