/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.active;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.load.active.ActiveLoadPathHelper;
import org.apache.iotdb.db.storageengine.load.disk.ILoadDiskSelector;
import org.apache.iotdb.db.storageengine.rescon.disk.FolderManager;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveLoadUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveLoadUtil.class);
    private static volatile ILoadDiskSelector loadDiskSelector = ActiveLoadUtil.updateLoadDiskSelector();

    public static boolean loadTsFileAsyncToActiveDir(List<File> tsFiles, Map<String, String> loadAttributes, boolean isDeleteAfterLoad) {
        if (tsFiles == null || tsFiles.isEmpty()) {
            return true;
        }
        try {
            for (File file : tsFiles) {
                if (ActiveLoadUtil.loadTsFilesToActiveDir(loadAttributes, file, isDeleteAfterLoad)) continue;
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Fail to load tsfile to Active dir", (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean loadTsFilesToActiveDir(Map<String, String> loadAttributes, File file, boolean isDeleteAfterLoad) throws IOException {
        File targetFilePath;
        if (file == null) {
            return true;
        }
        try {
            targetFilePath = loadDiskSelector.selectTargetDirectory(file.getParentFile(), file.getName(), false, 0);
        }
        catch (Exception e) {
            LOGGER.warn("Fail to load disk space of file {}", (Object)file.getAbsolutePath(), (Object)e);
            return false;
        }
        if (targetFilePath == null) {
            LOGGER.warn("Load active listening dir is not set.");
            return false;
        }
        Map<String, String> attributes = Objects.nonNull(loadAttributes) ? loadAttributes : Collections.emptyMap();
        File targetDir = ActiveLoadPathHelper.resolveTargetDir(targetFilePath, attributes);
        ActiveLoadUtil.loadTsFileAsyncToTargetDir(targetDir, new File(file.getAbsolutePath() + ".resource"), isDeleteAfterLoad);
        ActiveLoadUtil.loadTsFileAsyncToTargetDir(targetDir, new File(file.getAbsolutePath() + ".mods"), isDeleteAfterLoad);
        ActiveLoadUtil.loadTsFileAsyncToTargetDir(targetDir, file, isDeleteAfterLoad);
        return true;
    }

    public static boolean loadFilesToActiveDir(Map<String, String> loadAttributes, List<String> files, boolean isDeleteAfterLoad) throws IOException {
        File targetFilePath;
        if (files == null || files.isEmpty()) {
            return true;
        }
        try {
            File file = new File(files.get(0));
            targetFilePath = loadDiskSelector.selectTargetDirectory(file.getParentFile(), file.getName(), false, 0);
        }
        catch (Exception e) {
            LOGGER.warn("Fail to load disk space of file {}", (Object)files.get(0), (Object)e);
            return false;
        }
        if (targetFilePath == null) {
            LOGGER.warn("Load active listening dir is not set.");
            return false;
        }
        Map<String, String> attributes = Objects.nonNull(loadAttributes) ? loadAttributes : Collections.emptyMap();
        File targetDir = ActiveLoadPathHelper.resolveTargetDir(targetFilePath, attributes);
        for (String file : files) {
            ActiveLoadUtil.loadTsFileAsyncToTargetDir(targetDir, new File(file), isDeleteAfterLoad);
        }
        return true;
    }

    private static void loadTsFileAsyncToTargetDir(File targetDir, File file, boolean isDeleteAfterLoad) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!(targetDir.exists() || targetDir.mkdirs() || targetDir.exists())) {
            throw new IOException("Failed to create target directory " + targetDir.getAbsolutePath());
        }
        RetryUtils.retryOnException(() -> {
            if (isDeleteAfterLoad) {
                FileUtils.moveFileWithMD5Check((File)file, (File)targetDir);
            } else {
                FileUtils.copyFileWithMD5Check((File)file, (File)targetDir);
            }
            return null;
        });
    }

    public static ILoadDiskSelector updateLoadDiskSelector() {
        ILoadDiskSelector loadDiskSelector;
        String[] dirs = IoTDBDescriptor.getInstance().getConfig().getLoadActiveListeningDirs();
        FolderManager folderManager = null;
        DiskSpaceInsufficientException exception = null;
        try {
            folderManager = new FolderManager(Arrays.asList(dirs), DirectoryStrategyType.SEQUENCE_STRATEGY);
        }
        catch (DiskSpaceInsufficientException e) {
            exception = e;
            LOGGER.warn("Failed to load active listening dirs", (Throwable)((Object)e));
        }
        FolderManager finalFolderManager = folderManager;
        DiskSpaceInsufficientException finalException = exception;
        ActiveLoadUtil.loadDiskSelector = loadDiskSelector = ILoadDiskSelector.initDiskSelector(IoTDBDescriptor.getInstance().getConfig().getLoadDiskSelectStrategy(), dirs, (sourceDir, fileName, tierLevel) -> {
            if (finalException != null) {
                throw finalException;
            }
            return new File(finalFolderManager.getNextFolder());
        });
        return loadDiskSelector;
    }
}

