/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.apache.iotdb.metrics.utils.SystemTag;

public class JvmThreadMetrics
implements IMetricSet {
    private static long lastUpdateTime = 0L;
    private static final Map<Thread.State, Integer> threadStateCountMap = new EnumMap<Thread.State, Integer>(Thread.State.class);

    @Override
    public void bindTo(AbstractMetricService metricService) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        metricService.createAutoGauge(SystemMetric.JVM_THREADS_PEAK_THREADS.toString(), MetricLevel.CORE, threadBean, ThreadMXBean::getPeakThreadCount, new String[0]);
        metricService.createAutoGauge(SystemMetric.JVM_THREADS_DAEMON_THREADS.toString(), MetricLevel.CORE, threadBean, ThreadMXBean::getDaemonThreadCount, new String[0]);
        metricService.createAutoGauge(SystemMetric.JVM_THREADS_LIVE_THREADS.toString(), MetricLevel.CORE, threadBean, ThreadMXBean::getThreadCount, new String[0]);
        try {
            threadBean.getAllThreadIds();
            for (Thread.State state : Thread.State.values()) {
                metricService.createAutoGauge(SystemMetric.JVM_THREADS_STATUS_THREADS.toString(), MetricLevel.CORE, threadBean, bean -> JvmThreadMetrics.getThreadStateCount(bean, state), SystemTag.STATE.toString(), JvmThreadMetrics.getStateTagValue(state));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_THREADS_PEAK_THREADS.toString(), new String[0]);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_THREADS_DAEMON_THREADS.toString(), new String[0]);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_THREADS_LIVE_THREADS.toString(), new String[0]);
        try {
            threadBean.getAllThreadIds();
            for (Thread.State state : Thread.State.values()) {
                metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_THREADS_STATUS_THREADS.toString(), SystemTag.STATE.toString(), JvmThreadMetrics.getStateTagValue(state));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static long getThreadStateCount(ThreadMXBean threadBean, Thread.State state) {
        JvmThreadMetrics.checkAndUpdate(threadBean);
        return threadStateCountMap.getOrDefault((Object)state, 0).intValue();
    }

    private static void checkAndUpdate(ThreadMXBean threadBean) {
        if (System.currentTimeMillis() - lastUpdateTime < 10000L) {
            return;
        }
        lastUpdateTime = System.currentTimeMillis();
        threadStateCountMap.clear();
        List<ThreadInfo> infoList = Arrays.asList(threadBean.getThreadInfo(threadBean.getAllThreadIds()));
        infoList.forEach(info -> {
            if (info != null) {
                Thread.State state = info.getThreadState();
                threadStateCountMap.compute(state, (k, v) -> v == null ? 1 : v + 1);
            }
        });
    }

    private static String getStateTagValue(Thread.State state) {
        return state.name().toLowerCase().replace("_", "-");
    }
}

