/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class CancelRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=477");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=479");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=478");
    private final RequestHeader requestHeader;
    private final UInteger requestHandle;

    public CancelRequest(RequestHeader requestHeader, UInteger requestHandle) {
        this.requestHeader = requestHeader;
        this.requestHandle = requestHandle;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getRequestHandle() {
        return this.requestHandle;
    }

    protected CancelRequest(CancelRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((CancelRequestBuilder)b).requestHeader;
        this.requestHandle = ((CancelRequestBuilder)b).requestHandle;
    }

    public static CancelRequestBuilder<?, ?> builder() {
        return new CancelRequestBuilderImpl();
    }

    public CancelRequestBuilder<?, ?> toBuilder() {
        return new CancelRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelRequest)) {
            return false;
        }
        CancelRequest other = (CancelRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        UInteger this$requestHandle = this.getRequestHandle();
        UInteger other$requestHandle = other.getRequestHandle();
        return !(this$requestHandle == null ? other$requestHandle != null : !((Object)this$requestHandle).equals(other$requestHandle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CancelRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        UInteger $requestHandle = this.getRequestHandle();
        result = result * 59 + ($requestHandle == null ? 43 : ((Object)$requestHandle).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CancelRequest(requestHeader=" + this.getRequestHeader() + ", requestHandle=" + this.getRequestHandle() + ")";
    }

    private static final class CancelRequestBuilderImpl
    extends CancelRequestBuilder<CancelRequest, CancelRequestBuilderImpl> {
        private CancelRequestBuilderImpl() {
        }

        @Override
        protected CancelRequestBuilderImpl self() {
            return this;
        }

        @Override
        public CancelRequest build() {
            return new CancelRequest(this);
        }
    }

    public static abstract class CancelRequestBuilder<C extends CancelRequest, B extends CancelRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private UInteger requestHandle;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CancelRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CancelRequest instance, CancelRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.requestHandle(instance.requestHandle);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B requestHandle(UInteger requestHandle) {
            this.requestHandle = requestHandle;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CancelRequest.CancelRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", requestHandle=" + this.requestHandle + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<CancelRequest> {
        @Override
        public Class<CancelRequest> getType() {
            return CancelRequest.class;
        }

        @Override
        public CancelRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger requestHandle = decoder.readUInt32("RequestHandle");
            return new CancelRequest(requestHeader, requestHandle);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CancelRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32("RequestHandle", value.getRequestHandle());
        }
    }
}

