/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public abstract class FixupTypes
extends TypeUtil.CustomOrderSchemaVisitor<Type> {
    private final Schema referenceSchema;
    private Type sourceType;

    protected FixupTypes(Schema referenceSchema) {
        this.referenceSchema = referenceSchema;
        this.sourceType = referenceSchema.asStruct();
    }

    public Type schema(Schema schema, Supplier<Type> future) {
        this.sourceType = this.referenceSchema.asStruct();
        return future.get();
    }

    public Type struct(Types.StructType struct, Iterable<Type> fieldTypes) {
        Preconditions.checkArgument((boolean)this.sourceType.isStructType(), (String)"Not a struct: %s", (Object)this.sourceType);
        List fields = struct.fields();
        int length = fields.size();
        ArrayList types = Lists.newArrayList(fieldTypes);
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)length);
        boolean hasChange = false;
        for (int i = 0; i < length; ++i) {
            Types.NestedField field = (Types.NestedField)fields.get(i);
            Type resultType = (Type)types.get(i);
            if (field.type() == resultType) {
                newFields.add(field);
                continue;
            }
            if (field.isRequired()) {
                hasChange = true;
                newFields.add(Types.NestedField.required((int)field.fieldId(), (String)field.name(), (Type)resultType, (String)field.doc()));
                continue;
            }
            hasChange = true;
            newFields.add(Types.NestedField.optional((int)field.fieldId(), (String)field.name(), (Type)resultType, (String)field.doc()));
        }
        if (hasChange) {
            return Types.StructType.of((List)newFields);
        }
        return struct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type field(Types.NestedField field, Supplier<Type> future) {
        Preconditions.checkArgument((boolean)this.sourceType.isStructType(), (String)"Not a struct: %s", (Object)this.sourceType);
        Types.StructType sourceStruct = this.sourceType.asStructType();
        Types.NestedField sourceField = sourceStruct.field(field.fieldId());
        if (sourceField != null) {
            this.sourceType = sourceField.type();
            try {
                Type type = future.get();
                return type;
            }
            finally {
                this.sourceType = sourceStruct;
            }
        }
        return field.type();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type list(Types.ListType list, Supplier<Type> elementTypeFuture) {
        Preconditions.checkArgument((boolean)this.sourceType.isListType(), (String)"Not a list: %s", (Object)this.sourceType);
        Types.ListType sourceList = this.sourceType.asListType();
        this.sourceType = sourceList.elementType();
        try {
            Type elementType = elementTypeFuture.get();
            if (list.elementType() == elementType) {
                Types.ListType listType = list;
                return listType;
            }
            if (list.isElementOptional()) {
                Types.ListType listType = Types.ListType.ofOptional((int)list.elementId(), (Type)elementType);
                return listType;
            }
            Types.ListType listType = Types.ListType.ofRequired((int)list.elementId(), (Type)elementType);
            return listType;
        }
        finally {
            this.sourceType = sourceList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type map(Types.MapType map, Supplier<Type> keyTypeFuture, Supplier<Type> valueTypeFuture) {
        Preconditions.checkArgument((boolean)this.sourceType.isMapType(), (String)"Not a map: %s", (Object)this.sourceType);
        Types.MapType sourceMap = this.sourceType.asMapType();
        try {
            this.sourceType = sourceMap.keyType();
            Type keyType = keyTypeFuture.get();
            this.sourceType = sourceMap.valueType();
            Type valueType = valueTypeFuture.get();
            if (map.keyType() == keyType && map.valueType() == valueType) {
                Types.MapType mapType = map;
                return mapType;
            }
            if (map.isValueOptional()) {
                Types.MapType mapType = Types.MapType.ofOptional((int)map.keyId(), (int)map.valueId(), (Type)keyType, (Type)valueType);
                return mapType;
            }
            Types.MapType mapType = Types.MapType.ofRequired((int)map.keyId(), (int)map.valueId(), (Type)keyType, (Type)valueType);
            return mapType;
        }
        finally {
            this.sourceType = sourceMap;
        }
    }

    public Type variant(Types.VariantType variant) {
        return variant;
    }

    public Type primitive(Type.PrimitiveType primitive) {
        if (this.sourceType.equals(primitive)) {
            return primitive;
        }
        if (this.fixupPrimitive(primitive, this.sourceType)) {
            return this.sourceType;
        }
        return primitive;
    }

    protected abstract boolean fixupPrimitive(Type.PrimitiveType var1, Type var2);
}

