/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.metrics;

import io.micrometer.core.instrument.Tags;
import io.quarkus.micrometer.runtime.HttpServerMetricsTagsContributor;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerRequest;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.context.RealmContextResolver;
import org.apache.polaris.service.quarkus.metrics.QuarkusMetricsConfiguration;

@ApplicationScoped
public class RealmIdTagContributor
implements HttpServerMetricsTagsContributor {
    public static final String TAG_REALM = "realm_id";
    private static final Tags UNFINISHED_RESOLUTION_TAGS = Tags.of((String)"realm_id", (String)"???");
    @Inject
    QuarkusMetricsConfiguration metricsConfiguration;
    @Inject
    RealmContextResolver realmContextResolver;

    public Tags contribute(HttpServerMetricsTagsContributor.Context context) {
        if (!this.metricsConfiguration.realmIdTag().enableInHttpMetrics()) {
            return Tags.empty();
        }
        HttpServerRequest request = context.request();
        try {
            return this.realmContextResolver.resolveRealmContext(request.absoluteURI(), request.method().name(), request.path(), arg_0 -> ((MultiMap)request.headers()).get(arg_0)).thenApply(this::successfulResolutionTags).toCompletableFuture().getNow(UNFINISHED_RESOLUTION_TAGS);
        }
        catch (Exception e) {
            return Tags.empty();
        }
    }

    private Tags successfulResolutionTags(RealmContext realmContext) {
        return Tags.of((String)TAG_REALM, (String)realmContext.getRealmIdentifier());
    }
}

