/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.realm.tomcat;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.Principal;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.realm.RealmBase;
import org.apache.directory.fortress.realm.tomcat.TcAccessMgr;
import org.apache.directory.fortress.realm.util.ChildFirstUrlClassLoader;
import org.apache.directory.fortress.realm.util.CpUtil;

public class Tc7AccessMgrProxy
extends RealmBase {
    private static final String CLS_NM = Tc7AccessMgrProxy.class.getName();
    private static final Logger LOG = Logger.getLogger(CLS_NM);
    private static final String REALM_IMPL = "org.apache.directory.fortress.realm.tomcat.TcAccessMgrImpl";
    private static final String REALM_CLASSPATH = "REALM_CLASSPATH";
    private static final String JBOSS_AGENT = "jboss";
    private String CONTAINER = "Catalina7";
    private String defaultRoles;
    private String realmClasspath;
    private String contextId;
    private TcAccessMgr realm;

    private void initialize() {
        try {
            URLClassLoader ucl;
            URL[] cp;
            if (this.CONTAINER.equalsIgnoreCase(JBOSS_AGENT)) {
                LOG.info(CLS_NM + ".initialize JBoss policy agent");
                cp = CpUtil.getRealmClasspath(REALM_CLASSPATH);
                ucl = new ChildFirstUrlClassLoader(cp, ((Object)((Object)this)).getClass().getClassLoader());
            } else if (this.CONTAINER.equalsIgnoreCase("TomcatContext")) {
                LOG.info(CLS_NM + ".initialize Tomcat7 Context-based policy agent");
                ucl = new URLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
            } else {
                LOG.info(CLS_NM + ".initialize Tomcat7 policy agent");
                if (this.realmClasspath != null && this.realmClasspath.length() > 0) {
                    ucl = new URLClassLoader(CpUtil.parseRealmClasspath(this.realmClasspath), ((Object)((Object)this)).getClass().getClassLoader());
                } else {
                    cp = CpUtil.getRealmClasspath(REALM_CLASSPATH);
                    ucl = new URLClassLoader(cp, ((Object)((Object)this)).getClass().getClassLoader());
                }
            }
            LOG.info(CLS_NM + ".initialize - instantiate policy agent name: org.apache.directory.fortress.realm.tomcat.TcAccessMgrImpl");
            Class<?> sc = ucl.loadClass(REALM_IMPL);
            this.realm = (TcAccessMgr)sc.newInstance();
            this.realm.setDefaultRoles(this.defaultRoles);
            this.realm.setContextId(this.contextId);
            LOG.info(CLS_NM + " J2EE Tomcat7 policy agent, contextId: " + this.contextId + ", defaultRoles: " + this.defaultRoles);
        }
        catch (ClassNotFoundException e) {
            String error = CLS_NM + ".initialize caught java.lang.ClassNotFoundException=" + e.toString();
            LOG.severe(error);
            throw new RuntimeException(error, e);
        }
        catch (InstantiationException ie) {
            String error = CLS_NM + ".initialize caught java.lang.InstantiationException=" + ie.toString();
            LOG.severe(error);
            throw new RuntimeException(error, ie);
        }
        catch (IllegalAccessException iae) {
            String error = CLS_NM + ".initialize caught java.lang.IllegalAccessException=" + iae.toString();
            LOG.severe(error);
            throw new RuntimeException(error, iae);
        }
    }

    public Principal authenticate(String userId, String password) {
        if (this.realm == null) {
            throw new IllegalArgumentException(CLS_NM + "authenticate detected Fortress Tomcat7 Realm not initialized correctly.  Check your Fortress Realm configuration");
        }
        return this.realm.authenticate(userId, password);
    }

    public boolean hasRole(Wrapper wrapper, Principal principal, String role) {
        if (this.realm == null) {
            throw new IllegalArgumentException(CLS_NM + "authenticate detected Fortress Tomcat7 Realm not initialized correctly.  Check your Fortress Realm configuration");
        }
        return this.realm.hasRole(principal, role);
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }

    protected void startInternal() throws LifecycleException {
        try {
            this.initialize();
        }
        catch (Exception e) {
            String error = CLS_NM + ".startInternal caught Exception=" + e;
            LOG.severe(error);
            e.printStackTrace();
            throw new LifecycleException(error);
        }
        super.startInternal();
    }

    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.realm = null;
    }

    public String getContainerType() {
        return this.CONTAINER;
    }

    public void setContainerType(String container) {
        LOG.info(CLS_NM + ".setContainerType <" + container + ">");
        this.CONTAINER = container;
    }

    public String getRealmClasspath() {
        LOG.info(CLS_NM + ".getRealmClasspath <" + this.realmClasspath + ">");
        return this.realmClasspath;
    }

    public void setRealmClasspath(String rCpth) {
        LOG.info(CLS_NM + ".setRealmClasspath <" + rCpth + ">");
        this.realmClasspath = rCpth;
    }

    public String getDefaultRoles() {
        LOG.info(CLS_NM + ".getDefaultRoles <" + this.defaultRoles + ">");
        return this.defaultRoles;
    }

    public void setDefaultRoles(String defaultRoles) {
        LOG.info(CLS_NM + ".setDefaultRoles <" + defaultRoles + ">");
        this.defaultRoles = defaultRoles;
    }

    public String getContextId() {
        LOG.info(CLS_NM + ".getContextId <" + this.contextId + ">");
        return this.contextId;
    }

    public void setContextId(String contextId) {
        LOG.info(CLS_NM + ".setContextId <" + contextId + ">");
        this.contextId = contextId;
    }
}

