/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.annotation.AdminPermissionOperation;
import org.apache.directory.fortress.core.AdminMgr;
import org.apache.directory.fortress.core.AdminMgrFactory;
import org.apache.directory.fortress.core.DelAdminMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.AdminRoleP;
import org.apache.directory.fortress.core.impl.AdminRoleUtil;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.impl.OrgUnitP;
import org.apache.directory.fortress.core.impl.PermP;
import org.apache.directory.fortress.core.impl.PsoUtil;
import org.apache.directory.fortress.core.impl.UserP;
import org.apache.directory.fortress.core.impl.UsoUtil;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.Hier;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Relationship;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.util.VUtil;

public final class DelAdminMgrImpl
extends Manageable
implements DelAdminMgr,
Serializable {
    private static final String CLS_NM = DelAdminMgrImpl.class.getName();
    private OrgUnitP ouP = new OrgUnitP();
    private AdminRoleP admRP = new AdminRoleP();
    private PermP permP = new PermP();
    private UserP userP = new UserP();

    @Override
    @AdminPermissionOperation
    public AdminRole addRole(AdminRole role) throws SecurityException {
        String methodName = "addRole";
        this.assertContext(CLS_NM, methodName, role, 9007);
        this.setEntitySession(CLS_NM, methodName, role);
        return this.admRP.add(role);
    }

    @Override
    @AdminPermissionOperation
    public void deleteRole(AdminRole role) throws SecurityException {
        String methodName = "deleteRole";
        this.assertContext(CLS_NM, methodName, role, 9007);
        this.setEntitySession(CLS_NM, methodName, role);
        int numChildren = AdminRoleUtil.numChildren(role.getName(), role.getContextId());
        if (numChildren > 0) {
            String error = methodName + " role [" + role.getName() + "] must remove [" + numChildren + "] descendants before deletion";
            throw new SecurityException(5058, error, null);
        }
        List<User> users = this.userP.getAssignedUsers(role);
        if (users != null) {
            for (User ue : users) {
                User user = new User(ue.getUserId());
                UserAdminRole uAdminRole = new UserAdminRole(ue.getUserId(), role.getName());
                uAdminRole.setContextId(this.contextId);
                this.setAdminData(CLS_NM, methodName, user);
                this.deassignUser(uAdminRole);
            }
        }
        this.permP.remove(role);
        Set<String> parents = AdminRoleUtil.getParents(role.getName(), this.contextId);
        if (parents != null) {
            for (String parent : parents) {
                AdminRoleUtil.updateHier(this.contextId, new Relationship(role.getName().toUpperCase(), parent.toUpperCase()), Hier.Op.REM);
            }
        }
        this.admRP.delete(role);
    }

    @Override
    @AdminPermissionOperation
    public AdminRole updateRole(AdminRole role) throws SecurityException {
        String methodName = "updateRole";
        this.assertContext(CLS_NM, methodName, role, 9007);
        this.setEntitySession(CLS_NM, methodName, role);
        AdminRole re = this.admRP.update(role);
        List<User> users = this.userP.getAssignedUsers(role);
        if (CollectionUtils.isNotEmpty(users)) {
            AdminMgr aMgr = AdminMgrFactory.createInstance(this.contextId);
            for (User ue : users) {
                User upUe = new User(ue.getUserId());
                this.setAdminData(CLS_NM, methodName, upUe);
                List<UserAdminRole> uaRoles = ue.getAdminRoles();
                UserAdminRole chgRole = new UserAdminRole();
                chgRole.setName(role.getName());
                chgRole.setUserId(ue.getUserId());
                chgRole.setOsPSet(role.getOsPSet());
                chgRole.setOsUSet(role.getOsUSet());
                uaRoles.remove(chgRole);
                ConstraintUtil.copy(re, chgRole);
                uaRoles.add(chgRole);
                upUe.setUserId(ue.getUserId());
                upUe.setAdminRole(chgRole);
                aMgr.updateUser(upUe);
            }
        }
        return re;
    }

    @Override
    @AdminPermissionOperation
    public void assignUser(UserAdminRole uAdminRole) throws SecurityException {
        String methodName = "assignUser";
        this.assertContext(CLS_NM, methodName, uAdminRole, 9007);
        this.setEntitySession(CLS_NM, methodName, uAdminRole);
        AdminRole adminRole = new AdminRole(uAdminRole.getName());
        adminRole.setContextId(uAdminRole.getContextId());
        AdminRole validRole = this.admRP.read(adminRole);
        ConstraintUtil.validateOrCopy(validRole, uAdminRole);
        this.userP.copyAdminAttrs(validRole, uAdminRole);
        String dn = this.userP.assign(uAdminRole);
        this.setAdminData(CLS_NM, methodName, validRole);
        this.admRP.assign(validRole, dn);
    }

    @Override
    @AdminPermissionOperation
    public void deassignUser(UserAdminRole uAdminRole) throws SecurityException {
        String methodName = "deassignUser";
        this.assertContext(CLS_NM, methodName, uAdminRole, 9007);
        this.setEntitySession(CLS_NM, methodName, uAdminRole);
        String dn = this.userP.deassign(uAdminRole);
        AdminRole adminRole = new AdminRole(uAdminRole.getName());
        this.setAdminData(CLS_NM, methodName, adminRole);
        this.admRP.deassign(adminRole, dn);
    }

    @Override
    @AdminPermissionOperation
    public OrgUnit add(OrgUnit entity) throws SecurityException {
        String methodName = "addOU";
        this.assertContext(CLS_NM, methodName, entity, 8001);
        this.setEntitySession(CLS_NM, methodName, entity);
        VUtil.assertNotNull((Object)entity.getType(), 8002, CLS_NM + "." + methodName);
        return this.ouP.add(entity);
    }

    @Override
    @AdminPermissionOperation
    public OrgUnit update(OrgUnit entity) throws SecurityException {
        String methodName = "updateOU";
        this.assertContext(CLS_NM, methodName, entity, 8001);
        this.setEntitySession(CLS_NM, methodName, entity);
        VUtil.assertNotNull((Object)entity.getType(), 8002, CLS_NM + "." + methodName);
        return this.ouP.update(entity);
    }

    @Override
    @AdminPermissionOperation
    public OrgUnit delete(OrgUnit entity) throws SecurityException {
        Set<String> parents;
        String methodName = "deleteOU";
        this.assertContext(CLS_NM, methodName, entity, 8001);
        this.setEntitySession(CLS_NM, methodName, entity);
        VUtil.assertNotNull((Object)entity.getType(), 8002, CLS_NM + "." + methodName);
        int numChildren = entity.getType() == OrgUnit.Type.USER ? UsoUtil.getInstance().numChildren(entity.getName(), entity.getContextId()) : PsoUtil.getInstance().numChildren(entity.getName(), entity.getContextId());
        if (numChildren > 0) {
            String error = methodName + " orgunit [" + entity.getName() + "] must remove [" + numChildren + "] descendants before deletion";
            throw new SecurityException(5058, error, null);
        }
        if (entity.getType() == OrgUnit.Type.USER) {
            List<User> assignedUsers = this.userP.search(entity, true);
            if (CollectionUtils.isNotEmpty(assignedUsers)) {
                String error = methodName + " orgunit [" + entity.getName() + "] must unassign [" + assignedUsers.size() + "] users before deletion";
                throw new SecurityException(8020, error, null);
            }
        } else {
            List<PermObj> assignedPerms = this.permP.search(entity, false);
            if (CollectionUtils.isNotEmpty(assignedPerms)) {
                String error = methodName + " orgunit [" + entity.getName() + "] must unassign [" + assignedPerms.size() + "] perm objs before deletion";
                throw new SecurityException(8070, error, null);
            }
        }
        if ((parents = entity.getType() == OrgUnit.Type.USER ? UsoUtil.getInstance().getParents(entity.getName(), this.contextId) : PsoUtil.getInstance().getParents(entity.getName(), this.contextId)) != null) {
            for (String parent : parents) {
                if (entity.getType() == OrgUnit.Type.USER) {
                    UsoUtil.getInstance().updateHier(this.contextId, new Relationship(entity.getName().toUpperCase(), parent.toUpperCase()), Hier.Op.REM);
                    continue;
                }
                PsoUtil.getInstance().updateHier(this.contextId, new Relationship(entity.getName().toUpperCase(), parent.toUpperCase()), Hier.Op.REM);
            }
        }
        return this.ouP.delete(entity);
    }

    @Override
    @AdminPermissionOperation
    public void addDescendant(OrgUnit parent, OrgUnit child) throws SecurityException {
        String methodName = "addDescendantOU";
        this.assertContext(CLS_NM, methodName, parent, 8072);
        VUtil.assertNotNull((Object)parent.getType(), 8002, CLS_NM + "." + methodName);
        this.assertContext(CLS_NM, methodName, child, 8073);
        this.setEntitySession(CLS_NM, methodName, child);
        this.ouP.read(parent);
        if (parent.getType() == OrgUnit.Type.USER) {
            UsoUtil.getInstance().validateRelationship(child, parent, false);
        } else {
            PsoUtil.getInstance().validateRelationship(child, parent, false);
        }
        child.setParent(parent.getName());
        this.ouP.add(child);
        if (parent.getType() == OrgUnit.Type.USER) {
            UsoUtil.getInstance().updateHier(this.contextId, new Relationship(child.getName().toUpperCase(), parent.getName().toUpperCase()), Hier.Op.ADD);
        } else {
            PsoUtil.getInstance().updateHier(this.contextId, new Relationship(child.getName().toUpperCase(), parent.getName().toUpperCase()), Hier.Op.ADD);
        }
    }

    @Override
    @AdminPermissionOperation(operationName="addAscendantOU")
    public void addAscendant(OrgUnit child, OrgUnit parent) throws SecurityException {
        String methodName = "addAscendantOU";
        this.assertContext(CLS_NM, methodName, parent, 8072);
        VUtil.assertNotNull((Object)parent.getType(), 8002, CLS_NM + "." + methodName);
        this.setEntitySession(CLS_NM, methodName, parent);
        this.assertContext(CLS_NM, methodName, child, 8073);
        OrgUnit newChild = this.ouP.read(child);
        if (parent.getType() == OrgUnit.Type.USER) {
            UsoUtil.getInstance().validateRelationship(child, parent, false);
        } else {
            PsoUtil.getInstance().validateRelationship(child, parent, false);
        }
        this.ouP.add(parent);
        newChild.setParent(parent.getName());
        newChild.setContextId(this.contextId);
        this.ouP.update(newChild);
        if (parent.getType() == OrgUnit.Type.USER) {
            UsoUtil.getInstance().updateHier(this.contextId, new Relationship(child.getName().toUpperCase(), parent.getName().toUpperCase()), Hier.Op.ADD);
        } else {
            PsoUtil.getInstance().updateHier(this.contextId, new Relationship(child.getName().toUpperCase(), parent.getName().toUpperCase()), Hier.Op.ADD);
        }
    }

    @Override
    @AdminPermissionOperation(operationName="addInheritanceOU")
    public void addInheritance(OrgUnit parent, OrgUnit child) throws SecurityException {
        String methodName = "addInheritanceOU";
        this.assertContext(CLS_NM, methodName, parent, 8072);
        VUtil.assertNotNull((Object)parent.getType(), 8002, CLS_NM + "." + methodName);
        this.assertContext(CLS_NM, methodName, child, 8073);
        this.setEntitySession(CLS_NM, methodName, parent);
        if (parent.getType() == OrgUnit.Type.USER) {
            UsoUtil.getInstance().validateRelationship(child, parent, false);
        } else {
            PsoUtil.getInstance().validateRelationship(child, parent, false);
        }
        this.ouP.read(parent);
        OrgUnit cOrg = this.ouP.read(child);
        cOrg.setParent(parent.getName());
        cOrg.setContextId(this.contextId);
        this.setAdminData(CLS_NM, methodName, cOrg);
        this.ouP.update(cOrg);
        if (parent.getType() == OrgUnit.Type.USER) {
            UsoUtil.getInstance().updateHier(this.contextId, new Relationship(child.getName().toUpperCase(), parent.getName().toUpperCase()), Hier.Op.ADD);
        } else {
            PsoUtil.getInstance().updateHier(this.contextId, new Relationship(child.getName().toUpperCase(), parent.getName().toUpperCase()), Hier.Op.ADD);
        }
    }

    @Override
    @AdminPermissionOperation(operationName="deleteInheritanceOU")
    public void deleteInheritance(OrgUnit parent, OrgUnit child) throws SecurityException {
        String methodName = "deleteInheritanceOU";
        this.assertContext(CLS_NM, methodName, parent, 8072);
        VUtil.assertNotNull((Object)parent.getType(), 8002, CLS_NM + "." + methodName);
        this.assertContext(CLS_NM, methodName, child, 8073);
        this.setEntitySession(CLS_NM, methodName, parent);
        if (parent.getType() == OrgUnit.Type.USER) {
            UsoUtil.getInstance().validateRelationship(child, parent, true);
        } else {
            PsoUtil.getInstance().validateRelationship(child, parent, true);
        }
        if (parent.getType() == OrgUnit.Type.USER) {
            UsoUtil.getInstance().updateHier(this.contextId, new Relationship(child.getName().toUpperCase(), parent.getName().toUpperCase()), Hier.Op.REM);
        } else {
            PsoUtil.getInstance().updateHier(this.contextId, new Relationship(child.getName().toUpperCase(), parent.getName().toUpperCase()), Hier.Op.REM);
        }
        OrgUnit cOrg = this.ouP.read(child);
        cOrg.setContextId(this.contextId);
        cOrg.delParent(parent.getName());
        this.setAdminData(CLS_NM, methodName, cOrg);
        if (!CollectionUtils.isNotEmpty(cOrg.getParents())) {
            this.ouP.deleteParent(cOrg);
        } else {
            this.ouP.update(cOrg);
        }
    }

    @Override
    @AdminPermissionOperation
    public void addDescendant(AdminRole parentRole, AdminRole childRole) throws SecurityException {
        String methodName = "addDescendantRole";
        this.assertContext(CLS_NM, methodName, parentRole, 9019);
        this.assertContext(CLS_NM, methodName, childRole, 9020);
        this.setEntitySession(CLS_NM, methodName, childRole);
        this.admRP.read(parentRole);
        AdminRoleUtil.validateRelationship(childRole, parentRole, false);
        childRole.setParent(parentRole.getName());
        this.admRP.add(childRole);
        AdminRoleUtil.updateHier(this.contextId, new Relationship(childRole.getName().toUpperCase(), parentRole.getName().toUpperCase()), Hier.Op.ADD);
    }

    @Override
    @AdminPermissionOperation
    public void addAscendant(AdminRole childRole, AdminRole parentRole) throws SecurityException {
        String methodName = "addAscendantRole";
        this.assertContext(CLS_NM, methodName, parentRole, 9019);
        this.setEntitySession(CLS_NM, methodName, parentRole);
        this.assertContext(CLS_NM, methodName, childRole, 9020);
        AdminRole newChild = this.admRP.read(childRole);
        AdminRoleUtil.validateRelationship(childRole, parentRole, false);
        this.admRP.add(parentRole);
        AdminRole cRole2 = new AdminRole(childRole.getName());
        cRole2.setParents(newChild.getParents());
        cRole2.setParent(parentRole.getName());
        cRole2.setContextId(this.contextId);
        this.setAdminData(CLS_NM, methodName, cRole2);
        this.admRP.update(cRole2);
        AdminRoleUtil.updateHier(this.contextId, new Relationship(childRole.getName().toUpperCase(), parentRole.getName().toUpperCase()), Hier.Op.ADD);
    }

    @Override
    @AdminPermissionOperation
    public void addInheritance(AdminRole parentRole, AdminRole childRole) throws SecurityException {
        String methodName = "addInheritanceRole";
        this.assertContext(CLS_NM, methodName, parentRole, 9019);
        this.assertContext(CLS_NM, methodName, childRole, 9020);
        this.setEntitySession(CLS_NM, methodName, parentRole);
        this.admRP.read(parentRole);
        AdminRoleUtil.validateRelationship(childRole, parentRole, false);
        AdminRole cRole = new AdminRole(childRole.getName());
        cRole.setContextId(this.contextId);
        cRole = this.admRP.read(cRole);
        AdminRole cRole2 = new AdminRole(childRole.getName());
        cRole2.setParents(cRole.getParents());
        cRole2.setParent(parentRole.getName());
        cRole2.setContextId(this.contextId);
        this.setAdminData(CLS_NM, methodName, cRole2);
        AdminRoleUtil.updateHier(this.contextId, new Relationship(childRole.getName().toUpperCase(), parentRole.getName().toUpperCase()), Hier.Op.ADD);
        this.admRP.update(cRole2);
    }

    @Override
    @AdminPermissionOperation
    public void deleteInheritance(AdminRole parentRole, AdminRole childRole) throws SecurityException {
        String methodName = "deleteInheritanceRole";
        this.assertContext(CLS_NM, methodName, parentRole, 9019);
        this.assertContext(CLS_NM, methodName, childRole, 9020);
        this.setEntitySession(CLS_NM, methodName, parentRole);
        AdminRoleUtil.validateRelationship(childRole, parentRole, true);
        AdminRoleUtil.updateHier(this.contextId, new Relationship(childRole.getName().toUpperCase(), parentRole.getName().toUpperCase()), Hier.Op.REM);
        AdminRole cRole = new AdminRole(childRole.getName());
        cRole.setContextId(this.contextId);
        cRole = this.admRP.read(cRole);
        AdminRole cRole2 = new AdminRole(childRole.getName());
        cRole2.setParents(cRole.getParents());
        cRole2.delParent(parentRole.getName());
        cRole2.setContextId(this.contextId);
        this.setAdminData(CLS_NM, methodName, cRole2);
        if (!CollectionUtils.isNotEmpty(cRole2.getParents())) {
            this.admRP.deleteParent(cRole2);
        } else {
            this.admRP.update(cRole2);
        }
    }

    @Override
    public Permission addPermission(Permission perm) throws SecurityException {
        AdminMgr adminMgr = AdminMgrFactory.createInstance(this.contextId);
        perm.setAdmin(true);
        return adminMgr.addPermission(perm);
    }

    @Override
    public Permission updatePermission(Permission perm) throws SecurityException {
        AdminMgr adminMgr = AdminMgrFactory.createInstance(this.contextId);
        perm.setAdmin(true);
        return adminMgr.updatePermission(perm);
    }

    @Override
    public void deletePermission(Permission perm) throws SecurityException {
        AdminMgr adminMgr = AdminMgrFactory.createInstance(this.contextId);
        perm.setAdmin(true);
        adminMgr.deletePermission(perm);
    }

    @Override
    public PermObj addPermObj(PermObj pObj) throws SecurityException {
        AdminMgr adminMgr = AdminMgrFactory.createInstance(this.contextId);
        pObj.setAdmin(true);
        return adminMgr.addPermObj(pObj);
    }

    @Override
    public PermObj updatePermObj(PermObj pObj) throws SecurityException {
        AdminMgr adminMgr = AdminMgrFactory.createInstance(this.contextId);
        pObj.setAdmin(true);
        return adminMgr.updatePermObj(pObj);
    }

    @Override
    public void deletePermObj(PermObj pObj) throws SecurityException {
        AdminMgr adminMgr = AdminMgrFactory.createInstance(this.contextId);
        pObj.setAdmin(true);
        adminMgr.deletePermObj(pObj);
    }

    @Override
    public void grantPermission(Permission perm, AdminRole role) throws SecurityException {
        AdminMgr adminMgr = AdminMgrFactory.createInstance(this.contextId);
        perm.setAdmin(true);
        adminMgr.grantPermission(perm, role);
    }

    @Override
    public void revokePermission(Permission perm, AdminRole role) throws SecurityException {
        AdminMgr adminMgr = AdminMgrFactory.createInstance(this.contextId);
        perm.setAdmin(true);
        adminMgr.revokePermission(perm, role);
    }

    @Override
    public void grantPermission(Permission perm, User user) throws SecurityException {
        AdminMgr adminMgr = AdminMgrFactory.createInstance(this.contextId);
        perm.setAdmin(true);
        adminMgr.grantPermission(perm, user);
    }

    @Override
    public void revokePermission(Permission perm, User user) throws SecurityException {
        AdminMgr adminMgr = AdminMgrFactory.createInstance(this.contextId);
        perm.setAdmin(true);
        adminMgr.revokePermission(perm, user);
    }
}

