/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.OrgUnitDAO;
import org.apache.directory.fortress.core.model.Graphable;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.util.VUtil;
import org.apache.directory.fortress.core.util.cache.Cache;
import org.apache.directory.fortress.core.util.cache.CacheMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OrgUnitP {
    private static final String CLS_NM = OrgUnitP.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static final ReadWriteLock userPoolLock = new ReentrantReadWriteLock();
    private static final ReadWriteLock permPoolLock = new ReentrantReadWriteLock();
    private static Cache ouCache;
    private OrgUnitDAO oDao = new OrgUnitDAO();
    private static final String USER_OUS = "user.ous";
    private static final String PERM_OUS = "perm.ous";
    private static final String FORTRESS_OUS = "fortress.ous";

    private void init() {
        CacheMgr cacheMgr = CacheMgr.getInstance();
        ouCache = cacheMgr.getCache(FORTRESS_OUS);
    }

    OrgUnitP() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isValid(OrgUnit entity) {
        boolean result = false;
        if (entity.type == OrgUnit.Type.USER) {
            try {
                userPoolLock.readLock().lock();
                Set<String> userPool = this.getUserSet(entity);
                if (userPool == null) return result;
                result = userPool.contains(entity.getName());
                return result;
            }
            finally {
                userPoolLock.readLock().unlock();
            }
        }
        try {
            permPoolLock.readLock().lock();
            Set<String> permPool = this.getPermSet(entity);
            if (permPool == null) return result;
            result = permPool.contains(entity.getName());
            return result;
        }
        finally {
            permPoolLock.readLock().unlock();
        }
    }

    private Set<String> loadUserSet(OrgUnit orgUnit) {
        Set<String> ouUserSet = null;
        try {
            ouUserSet = this.oDao.getOrgs(orgUnit);
        }
        catch (SecurityException se) {
            String warning = "loadOrgSet static initializer caught SecurityException=" + se;
            LOG.info(warning, (Throwable)se);
        }
        ouCache.put(OrgUnitP.getKey(USER_OUS, orgUnit.getContextId()), ouUserSet);
        return ouUserSet;
    }

    private Set<String> loadPermSet(OrgUnit orgUnit) {
        Set<String> ouPermSet = null;
        try {
            ouPermSet = this.oDao.getOrgs(orgUnit);
        }
        catch (SecurityException se) {
            String warning = "loadOrgSet static initializer caught SecurityException=" + se;
            LOG.info(warning, (Throwable)se);
        }
        ouCache.put(OrgUnitP.getKey(PERM_OUS, orgUnit.getContextId()), ouPermSet);
        return ouPermSet;
    }

    private Set<String> getPermSet(OrgUnit orgUnit) {
        Set<String> permSet = (Set<String>)ouCache.get(OrgUnitP.getKey(PERM_OUS, orgUnit.getContextId()));
        if (permSet == null) {
            permSet = this.loadPermSet(orgUnit);
        }
        return permSet;
    }

    private Set<String> getUserSet(OrgUnit orgUnit) {
        Set<String> userSet = (Set<String>)ouCache.get(OrgUnitP.getKey(USER_OUS, orgUnit.getContextId()));
        if (userSet == null) {
            userSet = this.loadUserSet(orgUnit);
        }
        return userSet;
    }

    OrgUnit read(OrgUnit entity) throws SecurityException {
        this.validate(entity, false);
        return this.oDao.findByKey(entity);
    }

    List<OrgUnit> search(OrgUnit orgUnit) throws SecurityException {
        return this.oDao.findOrgs(orgUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    OrgUnit add(OrgUnit entity) throws SecurityException {
        this.validate(entity, false);
        OrgUnit oe = this.oDao.create(entity);
        if (entity.getType() == OrgUnit.Type.USER) {
            try {
                userPoolLock.writeLock().lock();
                Set<String> userPool = this.getUserSet(entity);
                if (userPool == null) return oe;
                userPool.add(entity.getName());
                return oe;
            }
            finally {
                userPoolLock.writeLock().unlock();
            }
        }
        try {
            permPoolLock.writeLock().lock();
            Set<String> permPool = this.getPermSet(entity);
            if (permPool == null) return oe;
            permPool.add(entity.getName());
            return oe;
        }
        finally {
            permPoolLock.writeLock().unlock();
        }
    }

    OrgUnit update(OrgUnit entity) throws SecurityException {
        this.validate(entity, false);
        return this.oDao.update(entity);
    }

    void deleteParent(OrgUnit entity) throws SecurityException {
        this.validate(entity, false);
        this.oDao.deleteParent(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    OrgUnit delete(OrgUnit entity) throws SecurityException {
        this.oDao.remove(entity);
        if (entity.getType() == OrgUnit.Type.USER) {
            try {
                userPoolLock.writeLock().lock();
                Set<String> userPool = this.getUserSet(entity);
                if (userPool == null) return entity;
                userPool.remove(entity.getName());
                return entity;
            }
            finally {
                userPoolLock.writeLock().unlock();
            }
        }
        try {
            permPoolLock.writeLock().lock();
            Set<String> permPool = this.getPermSet(entity);
            if (permPool == null) return entity;
            permPool.remove(entity.getName());
            return entity;
        }
        finally {
            permPoolLock.writeLock().unlock();
        }
    }

    List<Graphable> getAllDescendants(OrgUnit orgUnit) throws SecurityException {
        return this.oDao.getAllDescendants(orgUnit);
    }

    private void validate(OrgUnit entity, boolean isUpdate) throws SecurityException {
        VUtil.safeText(entity.getName(), 40);
        if (StringUtils.isNotEmpty((String)entity.getDescription())) {
            VUtil.description(entity.getDescription());
        }
        if (entity.getType() == null) {
            String error = "validate null or empty org unit type";
            throw new SecurityException(8002, error);
        }
    }

    private static String getKey(String type, String contextId) {
        Object key = type;
        if (StringUtils.isNotEmpty((String)contextId) && !contextId.equalsIgnoreCase("null")) {
            key = (String)key + ":" + contextId;
        }
        return key;
    }
}

