/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.cxf.plugin;

import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.security.SecurityContext;

public class FedizSecurityContext
implements SecurityContext {
    private Principal principal;
    private Set<Principal> roles;

    public FedizSecurityContext(Principal principal, Collection<String> roles) {
        this.principal = principal;
        this.roles = new HashSet<Principal>();
        if (roles != null) {
            for (String role : roles) {
                this.roles.add((Principal)new SimplePrincipal(role));
            }
        }
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        for (Principal p : this.roles) {
            if (!p.getName().equals(role)) continue;
            return true;
        }
        return false;
    }
}

