/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.annotation.Nonnull;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.dh.DHSupport;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.KeyAgreementSupport;
import org.opensaml.xmlsec.agreement.impl.AbstractKeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.impl.DigestMethod;
import org.opensaml.xmlsec.agreement.impl.KANonce;
import org.opensaml.xmlsec.agreement.impl.KeySize;
import org.opensaml.xmlsec.derivation.KeyDerivationException;
import org.opensaml.xmlsec.derivation.impl.DHLegacyKDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHWithLegacyKDFKeyAgreementProcessor
extends AbstractKeyAgreementProcessor {
    public static final String DEFAULT_DIGEST_METHOD = "http://www.w3.org/2001/04/xmlenc#sha256";
    private final Logger log = LoggerFactory.getLogger(DHWithLegacyKDFKeyAgreementProcessor.class);

    public String getAlgorithm() {
        return "http://www.w3.org/2001/04/xmlenc#dh";
    }

    @Override
    protected Credential obtainPrivateCredential(@Nonnull Credential publicCredential, @Nonnull KeyAgreementParameters parameters) throws KeyAgreementException {
        Credential suppliedCredential = super.obtainPrivateCredential(publicCredential, parameters);
        if (suppliedCredential != null) {
            return suppliedCredential;
        }
        this.log.debug("Found no supplied PrivateCredential in KeyAgreementParameters, generating ephemeral key pair");
        if (!DHPublicKey.class.isInstance(publicCredential.getPublicKey())) {
            throw new KeyAgreementException("Public credential's public key is not an instance of DHPublicKey");
        }
        DHPublicKey publicKey = (DHPublicKey)DHPublicKey.class.cast(publicCredential.getPublicKey());
        try {
            KeyPair privateKeyPair = DHSupport.generateCompatibleKeyPair((DHPublicKey)publicKey, null);
            return new BasicCredential(privateKeyPair.getPublic(), privateKeyPair.getPrivate());
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new KeyAgreementException("Error generating private KeyPair from DH public key", (Throwable)e);
        }
    }

    @Override
    protected byte[] generateAgreementSecret(@Nonnull Credential publicCredential, @Nonnull Credential privateCredential, @Nonnull KeyAgreementParameters parameters) throws KeyAgreementException {
        if (!DHPublicKey.class.isInstance(publicCredential.getPublicKey())) {
            throw new KeyAgreementException("Public credential's public key is not an instance of DHPublicKey");
        }
        if (!DHPrivateKey.class.isInstance(privateCredential.getPrivateKey())) {
            throw new KeyAgreementException("Private credential's private key is not an instance of DHPrivateKey");
        }
        DHPublicKey publicKey = (DHPublicKey)DHPublicKey.class.cast(publicCredential.getPublicKey());
        DHPrivateKey privateKey = (DHPrivateKey)DHPrivateKey.class.cast(privateCredential.getPrivateKey());
        try {
            return DHSupport.performKeyAgreement((DHPublicKey)publicKey, (DHPrivateKey)privateKey, null);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new KeyAgreementException("Error generating secret from public and private DH keys", (Throwable)e);
        }
    }

    @Override
    protected SecretKey deriveSecretKey(byte[] secret, @Nonnull String keyAlgorithm, @Nonnull KeyAgreementParameters parameters) throws KeyAgreementException {
        Integer keySize = parameters.contains(KeySize.class) ? ((KeySize)parameters.get(KeySize.class)).getSize() : null;
        KeyAgreementSupport.validateKeyAlgorithmAndSize((String)keyAlgorithm, (Integer)keySize);
        String digestMethod = null;
        if (parameters.contains(DigestMethod.class)) {
            digestMethod = ((DigestMethod)((Object)parameters.get(DigestMethod.class))).getAlgorithm();
        } else {
            digestMethod = DEFAULT_DIGEST_METHOD;
            DigestMethod dm = new DigestMethod();
            dm.setAlgorithm(digestMethod);
            parameters.add((Object)dm);
        }
        String nonce = null;
        if (parameters.contains(KANonce.class)) {
            nonce = ((KANonce)((Object)parameters.get(KANonce.class))).getValue();
        }
        DHLegacyKDF kdf = new DHLegacyKDF();
        kdf.setDigestMethod(digestMethod);
        kdf.setNonce(nonce);
        try {
            return kdf.derive(secret, keyAlgorithm, keySize);
        }
        catch (KeyDerivationException e) {
            throw new KeyAgreementException("Key derivation failed using supplied KeyDerivation parameter", (Throwable)e);
        }
    }
}

