/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

public class DoubleConverterTestCase
extends NumberConverterTestBase {
    private Converter converter;

    public static TestSuite suite() {
        return new TestSuite(DoubleConverterTestCase.class);
    }

    public DoubleConverterTestCase(String name) {
        super(name);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Double.class;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new DoubleConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new DoubleConverter(defaultValue);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = Double.valueOf("-12");
        this.numbers[1] = Double.valueOf("13");
        this.numbers[2] = Double.valueOf("-22");
        this.numbers[3] = Double.valueOf("23");
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Double.MIN_VALUE), "-17.2", "-1.1", "0.0", "1.1", "17.2", String.valueOf(Double.MAX_VALUE), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        Double[] expected = new Double[]{Double.MIN_VALUE, -17.2, -1.1, 0.0, 1.1, 17.2, Double.MAX_VALUE, 7.0, 8.0, 9.0, 10.0, 11.1, 12.2};
        for (int i = 0; i < expected.length; ++i) {
            DoubleConverterTestCase.assertEquals((String)(message[i] + " to Double"), (double)expected[i], (double)((Double)this.converter.convert(Double.class, input[i])), (double)1.0E-5);
            DoubleConverterTestCase.assertEquals((String)(message[i] + " to double"), (double)expected[i], (double)((Double)this.converter.convert(Double.TYPE, input[i])), (double)1.0E-5);
            DoubleConverterTestCase.assertEquals((String)(message[i] + " to null type"), (double)expected[i], (double)((Double)this.converter.convert(null, input[i])), (double)1.0E-5);
        }
    }
}

