/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.FluentIntrospectionTestBean;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class FluentPropertyBeanIntrospectorTestCase
extends TestCase {
    private static Map<String, PropertyDescriptor> createDescriptorMap(PropertyDescriptor[] descs) {
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor pd : descs) {
            map.put(pd.getName(), pd);
        }
        return map;
    }

    private static PropertyDescriptor fetchDescriptor(Map<String, PropertyDescriptor> props, String name) {
        FluentPropertyBeanIntrospectorTestCase.assertTrue((String)("Property not found: " + name), (boolean)props.containsKey(name));
        return props.get(name);
    }

    public void testInitNoPrefix() {
        try {
            new FluentPropertyBeanIntrospector(null);
            FluentPropertyBeanIntrospectorTestCase.fail((String)"Missing prefix for write methods not detected!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIntrospection() throws IntrospectionException {
        PropertyUtilsBean pu = new PropertyUtilsBean();
        FluentPropertyBeanIntrospector introspector = new FluentPropertyBeanIntrospector();
        pu.addBeanIntrospector((BeanIntrospector)introspector);
        Map<String, PropertyDescriptor> props = FluentPropertyBeanIntrospectorTestCase.createDescriptorMap(pu.getPropertyDescriptors(FluentIntrospectionTestBean.class));
        PropertyDescriptor pd = FluentPropertyBeanIntrospectorTestCase.fetchDescriptor(props, "name");
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"No read method for name", (Object)pd.getReadMethod());
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"No write method for name", (Object)pd.getWriteMethod());
        FluentPropertyBeanIntrospectorTestCase.fetchDescriptor(props, "stringProperty");
        pd = FluentPropertyBeanIntrospectorTestCase.fetchDescriptor(props, "fluentProperty");
        FluentPropertyBeanIntrospectorTestCase.assertNull((String)"Read method for fluentProperty", (Object)pd.getReadMethod());
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"No write method for fluentProperty", (Object)pd.getWriteMethod());
        pd = FluentPropertyBeanIntrospectorTestCase.fetchDescriptor(props, "fluentGetProperty");
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"No read method for fluentGetProperty", (Object)pd.getReadMethod());
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"No write method for fluentGetProperty", (Object)pd.getWriteMethod());
    }

    public void testIntrospectionCaps() throws Exception {
        PropertyUtilsBean pu = new PropertyUtilsBean();
        FluentPropertyBeanIntrospector introspector = new FluentPropertyBeanIntrospector();
        pu.addBeanIntrospector((BeanIntrospector)introspector);
        Map<String, PropertyDescriptor> props = FluentPropertyBeanIntrospectorTestCase.createDescriptorMap(pu.getPropertyDescriptors(CapsBean.class));
        PropertyDescriptor aDescriptor = FluentPropertyBeanIntrospectorTestCase.fetchDescriptor(props, "URI");
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"missing property", (Object)aDescriptor);
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"No read method for uri", (Object)aDescriptor.getReadMethod());
        FluentPropertyBeanIntrospectorTestCase.assertNotNull((String)"No write method for uri", (Object)aDescriptor.getWriteMethod());
        FluentPropertyBeanIntrospectorTestCase.assertNull((String)"Should not find mis-capitalized property", (Object)props.get("uRI"));
    }

    public static final class CapsBean {
        private URI mURI;

        public URI getURI() {
            return this.mURI;
        }

        public void setURI(URI theURI) {
            this.mURI = theURI;
        }
    }
}

