// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2008 Konrad Twardowski

#pragma once

#include <QActionGroup>
#include <QWidget>

using namespace std::chrono;

class Var;

class ProgressBar final: public QWidget {
public:
	enum class Size { Small = 2, Normal = 3, Medium = 6, Large = 9 };
	explicit ProgressBar();
	virtual ~ProgressBar() = default;
	Qt::Alignment alignment() const { return m_alignment; }
	void createSettingsMenu(QMenu *menu, const bool fullMode);
	void setAlignment(const Qt::Alignment value, const bool updateConfig, const bool authorize = false);
	void setDemo(const bool active);
	void setHeight(const int value);
	static void updateTaskbar(const double progress, const seconds &seconds);
	void updateValue(const seconds &secsTo, const seconds &totalSecs);
protected:
	virtual void contextMenuEvent(QContextMenuEvent *e) override;
	virtual void mousePressEvent(QMouseEvent *e) override;
	virtual void paintEvent(QPaintEvent *e) override;
private:
	Q_DISABLE_COPY(ProgressBar)
	int m_completeWidth = 0;
	int m_demoWidth = 0;
	Qt::Alignment m_alignment;
	QColor m_demoColor;
	QTimer *m_demoTimer;
	seconds m_secsTo = 0s;
	seconds m_totalSecs = 0s;
	Var *m_alignmentVar;
	Var *m_backgroundColorVar;
	Var *m_foregroundColorVar;
	Var *m_sizeVar;
	void makeIcon(QAction *action, const Qt::Alignment alignment, const int size);
	static void makeRadioButton(QAction *action, QActionGroup *group, const bool checked);
	void makeSizeRadioButton(QAction *action, QActionGroup *group, const Size size) {
		makeIcon(action, m_alignment, static_cast<int>(size));
		makeRadioButton(action, group, height() == static_cast<int>(size));
	}
	void setSize(const Size size, const bool authorize = false);
	void updatePalette();

	// event handlers:
	void onDemoTimeout();
	void onSetColor(const bool foreground);
};
